/*
** dir.c - list directory contents plugin module for mod_pluginclude.c
**
*/

#include "httpd.h"

char *create_content(request_rec *r, char *arg)
{
    DIR *dir;
    struct dirent *dirent;
    char *content = "";

    if (!(dir = ap_popendir(r->pool, arg))) {
        return ap_pstrcat(r->pool, "dir.so: cannot open directory ",
                          arg, NULL);
    }
    while ((dirent = readdir(dir)) != NULL) {
        content = ap_pstrcat(r->pool, content, dirent->d_name, "<br />\n", NULL);
    }
    ap_pclosedir(r->pool, dir);
    return content;
}
