/*
** httpget.c - resolver plugin module for mod_pluginclude.c
**
*/
#include "httpd.h"
#include "sys/socket.h"

char *create_content(request_rec *r, char *arg)
{
    uri_components url;
    int status;
    struct sockaddr_in server;
    struct hostent *h;
    int s;
    FILE *sock;
    char buffer[IOBUFSIZE];
    char *content = "";

    /* argURL */
    status = ap_parse_uri_components(r->pool, (const char *)arg, &url);
    if (!ap_is_HTTP_SUCCESS(status))
        return ap_pstrdup(r->pool, "cannot parse uri");
    if (strcmp(url.scheme, "http") != 0)
        return ap_pstrcat(r->pool, "unknown scheme: ", url.scheme, NULL);
    if (url.port == 0)
        url.port = ap_default_port_for_scheme(url.scheme);

    /* URLhostport³socket */
    if ((h = gethostbyname(url.hostname)) == NULL) {
        return ap_pstrcat(r->pool, "httpget.so: cannot resolv hostname: ",
                          url.hostname, NULL);
    }
    memset(&server, '\0', sizeof(server));
    memcpy((char *)&server.sin_addr, h->h_addr, h->h_length);
    server.sin_family = AF_INET;
    server.sin_port = htons((unsigned short)url.port);
    s = ap_psocket(r->pool, PF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (s == -1) {
        return ap_pstrdup(r->pool, "httpget.so: error creating socket");
    }

    /* timeoutꤷ³ */
    ap_hard_timeout("httpget.so http connect", r);
    if (connect(s, (struct sockaddr *)&server, sizeof(server)) < 0) {
        ap_pclosesocket(r->pool, s);
        return ap_pstrcat(r->pool, "httpget.so: cannot connect to ", arg, NULL);
    }
    /* socket descriptersocket stream */
    if ((sock = ap_pfdopen(r->pool, s, "r+")) == NULL)
        return ap_pstrdup(r->pool, "httpget.so: cannot create stream");

    /* HTTP GET request */
    fprintf(sock, "GET %s HTTP/1.0\nHost: %s\n\n",
            url.path ? url.path : "/",
            url.hostname);

    /* HTTP response headerɤФ */
    while (fgets(buffer, sizeof(buffer), sock) != NULL) {
        if (strcmp(buffer, "\n") == 0 || strcmp(buffer, "\r\n") == 0)
            break;
    }
    /* HTTP response body */
    while (fgets(buffer, sizeof(buffer), sock) != NULL) {
        content = ap_pstrcat(r->pool, content, buffer, NULL);
    }
    ap_pfclose(r->pool, sock);
    ap_kill_timeout(r);
    return content;
}
