require('script/moflib')
require('script/icon_manager')

ITEM_TYPE_POTION = 0
ITEM_TYPE_KNIGH  = 1
ITEM_TYPE_SWORD  = 2
ITEM_TYPE_BLADE  = 3
ITEM_TYPE_ROBE   = 4
ITEM_TYPE_ARMER  = 5

ELEMENT_TYPE_FOREST = 0
ELEMENT_TYPE_EARTH  = 1
ELEMENT_TYPE_WATER  = 2

--{{{ extension_tween
ExtensionTween = {}
function ExtensionTween:new()
	local instance = {}
	setmetatable(instance, {__call = 
		function (instance, obj) 
			local prop = obj:get_properties()
			local max_width, max_height = split(prop['preferred_size'], ',')
			local min_width = 50
			local min_height = 50
			local x, y = layout(0.5, max_width, 0.5, 0.7, min_height, 0.3) 
			obj:set_tween('open.position2', 
				{
					[0] = {x + (max_width - min_width) / 2, y + (max_height - min_height) / 2},
					[15] = {x, y + (max_height - min_height) / 2},
					[20] = {x, y}
				}, 20)
			obj:set_tween('close.position2', 
				{
					[0] = {x, y},
					[15] = {x, y + (max_height - min_height) / 2},
					[20] = {x + (max_width - min_width) / 2, y + (max_height - min_height) / 2},
				}, 20)
			obj:set_tween('open.size2', 
				{
					[0] = {min_width - max_width, min_height - max_height},
					[15] = {0, min_height - max_height},
					[20] = {0, 0},
				}, 20)
			obj:set_tween('close.size2', 
				{
					[0] = {0, 0},
					[15] = {0, min_height - max_height},
					[20] = {min_width - max_width, min_height - max_height},
				}, 20)
			obj:set_tween('open.color', {[0] = {1, 1, 1, 1}, [100] = {1, 1, 1, 1}}, 20)
			obj:set_tween('close.color', {[5] = {1, 1, 1, 1}, [20] = {0, 1, 1, 1}}, 20)
		end}) -- setmetatable
	return instance
end
--}}}
--{{{ right slide_tween
RightSlideTween = {}
function RightSlideTween:new(left_margin, top_margin, width, height, period)
	local instance = {}
	instance.left_margin   = left_margin
	instance.top_margin    = top_margin
	instance.width         = width
	instance.height        = height
	instance.period        = period

	setmetatable(instance, {__call = 
		function (instance, obj) 
			local prop = obj:get_properties()
			local old_width, old_height = split(prop['preferred_size'], ',')
			local x, y, w, h = to_client_coord(instance.left_margin, instance.top_margin, instance.width, instance.height)
			
			local period = instance.period
			obj:set_tween('open.position2', {[0] = {-w - old_width, y}, [period] = {x, y}}, 0)
			obj:set_tween('close.position2', {[0] = {x, y}, [period] = {-w - old_width, y}}, 0)
			if w ~= nil then obj:set_tween('open.size2', {[0] = {w - old_width, h - old_height}}, 0) end
			if h ~= nil then obj:set_tween('close.size2', {[0] = {w - old_width, h - old_height}}, 0) end
			obj:set_tween('close.color', {[period / 4] = {1, 1, 1, 1}, [period] = {0, 1, 1, 1}}, 0)
		end}) -- setmetatable
	return instance
end
--}}}
--{{{ up slide_tween
UpSlideTween = {}
function UpSlideTween:new(left_margin, top_margin, width, height, period)
	local instance = {}
	instance.left_margin   = left_margin
	instance.top_margin    = top_margin
	instance.width         = width
	instance.height        = height
	instance.period        = period

	setmetatable(instance, {__call = 
		function (instance, obj) 
			local prop = obj:get_properties()
			local old_width, old_height = split(prop['preferred_size'], ',')
			local x, y, w, h = to_client_coord(instance.left_margin, instance.top_margin, instance.width, instance.height)

			local data = load_game_data('system.client_region')
			local ch = data[1]['height']

			local period = instance.period
			obj:set_tween('open.position2', {[0] = {x, ch}, [period] = {x, y}}, period)
			obj:set_tween('close.position2', {[0] = {x, y}, [period] = {x, ch}}, period)
			if w ~= nil then obj:set_tween('open.size2', {[0] = {w - old_width, h - old_height}}, 0) end
			if h ~= nil then obj:set_tween('close.size2', {[0] = {w - old_width, h - old_height}}, 0) end
			obj:set_tween('close.color', {[period / 4] = {1, 1, 1, 1}, [period] = {0, 1, 1, 1}}, period)
		end}) -- setmetatable
	return instance
end
--}}}
--{{{ down slide_tween
DownSlideTween = {}
function DownSlideTween:new(left_margin, top_margin, width, height, period)
	local instance = {}
	instance.left_margin   = left_margin
	instance.top_margin    = top_margin
	instance.width         = width
	instance.height        = height
	instance.period        = period

	setmetatable(instance, {__call = 
		function (instance, obj) 
			local prop = obj:get_properties()
			local old_width, old_height = split(prop['preferred_size'], ',')
			local x, y, w, h = to_client_coord(instance.left_margin, instance.top_margin, instance.width, instance.height)

			local period = instance.period
			obj:set_tween('open.position2', {[0] = {x, -height - old_height}, [period] = {x, y}}, period)
			obj:set_tween('close.position2', {[0] = {x, y}, [period] = {x, -height - old_height}}, period)
			if w ~= nil then obj:set_tween('open.size2', {[0] = {w - old_width, h - old_height}}, 0) end
			if h ~= nil then obj:set_tween('close.size2', {[0] = {w - old_width, h - old_height}}, 0) end
			obj:set_tween('close.color', {[period / 4] = {1, 1, 1, 1}, [period] = {0, 1, 1, 1}}, period)
		end}) -- setmetatable
	return instance
end
--}}}
--{{{ default_tween
DefaultTween = {}
function DefaultTween:new(left_margin, top_margin, width, height)
	local instance = {}
	instance.left_margin = left_margin 
	instance.top_margin  = top_margin 
	instance.width       = width
	instance.height      = height

	setmetatable(instance, {__call = 
		function (instance, obj) 
			local prop = obj:get_properties()
			local old_width, old_height = split(prop['preferred_size'], ',')
			local x, y, w, h = to_client_coord(instance.left_margin, instance.top_margin, instance.width, instance.height)

			obj:set_tween('open.position2', {[0] = {x, y}})
			obj:set_tween('open.size2', {[0] = {w - old_width, h - old_height}})
			obj:set_tween('close.color', {[0] = {0, 1, 1, 1}})
		end}) -- setmetatable
	return instance
end
--}}}
--{{{ feed_tween
FeedTween = {}
function FeedTween:new(left_margin, top_margin, width, height)
	local instance = {}
	instance.left_margin   = left_margin
	instance.top_margin    = top_margin
	instance.width         = width
	instance.height        = height

	setmetatable(instance, {__call = 
		function (instance, obj) 
			local prop = obj:get_properties()
			local old_width, old_height = split(prop['preferred_size'], ',')
			local x, y, w, h = to_client_coord(instance.left_margin, instance.top_margin, instance.width, instance.height)

			obj:set_tween('open.position2', {[0] = {x, y}}, 0)
			obj:set_tween('close.position2', {[0] = {x, y}}, 0)
			if w ~= nil then obj:set_tween('open.size2', {[0] = {w - old_width, h - old_height}}, 0) end
			if h ~= nil then obj:set_tween('close.size2', {[0] = {w - old_width, h - old_height}}, 0) end
			obj:set_tween('open.color', {[0] = {0, 1, 1, 1}, [20] = {1, 1, 1, 1}}, 20)
			obj:set_tween('close.color', {[0] = {1, 1, 1, 1}, [20] = {0, 1, 1, 1}}, 20)
			
		end}) -- setmetatable
	return instance
end
--}}}
--{{{ landname_tween
LandNameTween = {}
function LandNameTween:new(x, y)
	local instance = {}
	instance.x   = x 
	instance.y   = y

	setmetatable(instance, {__call = 
		function (instance, obj) 
			--local prop = obj:get_properties()
			--local old_width, old_height = split(prop['preferred_size'], ',')
			--local x, y, w, h = to_client_coord(instance.left_margin, instance.top_margin, instance.width, instance.height)


			obj:set_tween('open.position2', {[0] = {0, 0}, ['world2client'] = {instance.x, 0, -instance.y}}, 0)
			obj:set_tween('close.position2', {[0] = {0, 0}, ['world2client'] = {instance.x, 0, -instance.y}}, 0)
			--if w ~= nil then obj:set_tween('open.size2', {[0] = {w - old_width, h - old_height}}, 0) end
			--if h ~= nil then obj:set_tween('close.size2', {[0] = {w - old_width, h - old_height}}, 0) end
			
		end}) -- setmetatable
	return instance
end
--}}}
--{{{ make_caption_text
function make_caption_text(text)
	return '<col code="cc8888"><font name="Vinque" size="40">' .. text .. '</font></col>'
end
--}}}
