require("script/moflib");
require('script/common')

--{{{ forest_element
function forest_element(x, y, z)
	sound('sound/element.wav')
	local b = Board:new('file.image/element.png')
	b:set_tween('position3', {[0] = {x, y + 0.5, z}, [90] = {x, y, z}})
	b:set_tween('texcoord', {[0] = {0, 1/8, 1/8, 2/8}})
	b:set_tween('color', {[0] = {1, 1, 1, 1}, [90] = {0, 1, 1, 1}})
	wait_frame(90)
	b:dispose()
	sound('sound/put_element.wav')
end
--}}}
--{{{ earth_element
function earth_element(x, y, z)
	sound('sound/element.wav')
	local b = Board:new('file.image/element.png')
	b:set_tween('position3', {[0] = {x, y + 0.5, z}, [90] = {x, y, z}})
	b:set_tween('texcoord', {[0] = {0, 2/8, 1/8, 3/8}})
	b:set_tween('color', {[0] = {1, 1, 1, 1}, [90] = {0, 1, 1, 1}})
	wait_frame(90)
	b:dispose()
	sound('sound/put_element.wav')
end
--}}}
--{{{ water_element
function water_element(x, y, z)
	sound('sound/element.wav')
	local b = Board:new('file.image/element.png')
	b:set_tween('position3', {[0] = {x, y + 0.5, z}, [90] = {x, y, z}})
	b:set_tween('texcoord', {[0] = {0, 3/8, 1/8, 4/8}})
	b:set_tween('color', {[0] = {1, 1, 1, 1}, [90] = {0, 1, 1, 1}})
	wait_frame(90)
	b:dispose()
	sound('sound/put_element.wav')
end
--}}}
