require('script/moflib')
require('script/common')
require('script/service_menu')
require('script/marcket_menu')

--{{{ make_service_text
function make_service_text(service)
	local text = '<layout w="300" h="24" xalign="left" yalign="center">' .. service.name .. '</layout>'
	text = text .. '<col code="ffff00">Grade' .. service.grade .. '</col>'
	return text
end
--}}}
--{{{ make_service_explanation
function make_service_explanation(service)
	print_debug(service)
	local syuzoku = 
		{{'ehves', tonumber(service.ehves)}, {'bolony', tonumber(service.bolony)}, {'stra', tonumber(service.stra)}}
	
	-- A͒x̂tableōœK
	local buf = {}
	table.insert(buf, service.explanation)
	table.insert(buf, '<nl/><col name="blue"><layout w="100" h="32" xalign="left" yalign="center"></layout></col>')
	for idx, val in ipairs(syuzoku) do
		table.insert(buf, get_icon_image_tag(val[1]) .. '<layout w="40" h="32" xalign="right" yalign="center">' .. val[2] .. '</layout>@@')
	end

	return table.concat(buf)
end
--}}}
--{{{ land_menu
function land_menu(x, y)

	local answer = 0
	local jem_text = text('', '<layout w="200" h="32" xalign="right" yalign="center">400JEM</layout>', '', FeedTween:new(0.05, 0.9, 0.3, 0.07))
	
	local services = load_game_data('gamedata.area_service.' .. x .. '.' .. y)
	local area = load_game_data('gamedata.area_profile.' .. x .. '.' .. y)
	local items = {}
	for idx, val in ipairs(services) do
		table.insert(items, make_service_text(val))
	end
	table.insert(items, '}[Pbg')

	local explanation_text = text('', make_service_explanation(services[1]), '', FeedTween:new(0.3, 0.7, 0.65, 0.1))

	while true do
		answer = question(make_caption_text('Land Menu'), items, nil, FeedTween:new(0.3, 0.25, 0.65, 0.4), false, 
			function (index)
				-- T[rX̐XV
				if index == #services then 
					explanation_text:next('bN𔄋pJEMɊł܂')
				else
					explanation_text:next(make_service_explanation(services[index + 1]))
				end
			end)
		if answer == 0 then
			break
		else
			if answer -1 == #services then 
				marcket_menu(jem_text, explanation_text, 
					tonumber(area[1].ehves_power), tonumber(area[1].bolony_power), tonumber(area[1].stra_power))
			else
				service_menu(jem_text, explanation_text, services[answer].id, services[answer].grade)
			end
			explanation_text:next(make_service_explanation(services[1]))
		end
	end
	jem_text:dispose()
	explanation_text:dispose()
end
--}}}
