require('script/moflib')
require('script/common')

--{{{ make_relic_price_helper
function make_relic_price_helper(relic_grade, land_power)
	local table = {}
	if land_power < 25 then
		table = {10, 14, 20, 9}
	elseif land_power < 50 then
		table = {7, 20, 28, 45}
	elseif land_power < 75 then
		table = {5, 14, 40, 63}
	else
		table = {1, 10, 28, 90}
	end
	return table[relic_grade]
end
--}}}
--{{{ make_relic_price
function make_relic_price(relic, ehves_power, bolony_power, stra_power)
	if relic.icon_type == 'ehves' then
		return make_relic_price_helper(tonumber(relic.grade), ehves_power)
	elseif relic.icon_type == 'bolony' then
		return make_relic_price_helper(tonumber(relic.grade), bolony_power)
	elseif relic.icon_type == 'stra' then
		return make_relic_price_helper(tonumber(relic.grade), stra_power)
	end
end
--}}}
--{{{ make_relic_text
function make_relic_text(item)
	local icon = get_icon_image_tag(item.icon_type)
	local text = '<layout w="250" h="32" xalign="left" yalign="center">' .. icon .. item.name .. '</layout>'
	text = text .. '<layout w="200" h="32" xalign="right" yalign="center">' .. item.num .. '</layout>'
	return text
end
--}}}
--{{{ make_marcket_relic_explanation
function make_marcket_relic_explanation(item, ehves_power, bolony_power, stra_power)
	local text = '<layout w="300" h="24" xalign="left" yalign="center">' .. item.explanation .. '</layout><nl/>'
	local price = make_relic_price(item, ehves_power, bolony_power, stra_power)
	text = text .. '<col name="blue">pP</col><layout w="120" h="24" xalign="right" yalign="center">' .. price .. 'JEM</layout>'
	return text
end
--}}}
--{{{ marcket_menu
function marcket_menu(jem_text, explanation_text, ehves_power, bolony_power, stra_power)

	local answer = 0

	local chara_pic = Picture:new('file.image/shop/bukiya.png')
	local x, y = to_client_coord(0.01, 0.1)
	chara_pic:set_tween('position2', {[0] = {x, y}}, 0)
	chara_pic:set_tween('size2', {[0] = {256 * 0.9, 512 * 0.9}}, 0) -- TODO

	local relic_list = load_game_data('gamedata.relic_profile')
	local items = {}
	for idx, val in ipairs(relic_list) do
		table.insert(items, make_relic_text(val))
	end

	explanation_text:next(make_marcket_relic_explanation(relic_list[1], ehves_power, bolony_power, stra_power))

	while true do
		answer = question('}[Pbg', items, nil, FeedTween:new(0.3, 0.25, 0.65, 0.4), false,
			function (index)
				explanation_text:next(make_marcket_relic_explanation(relic_list[index + 1], ehves_power, bolony_power, stra_power))
			end)
		break
	end

	chara_pic:dispose()


end
--}}}
