require('script/moflib')
require('script/common')
require('script/item')

--{{{ make_item_text
function make_item_text(item)
	local texts = {}
	table.insert(texts, get_icon_image_tag(item.icon_type))
	table.insert(texts, '<layout w="200" h="32" xalign="left" yalign="center">' .. item.name .. '</layout>')
	table.insert(texts, '<layout w="80" h="32" xalign="left" yalign="center"><col name="blue">cϐ</col></layout>')
	table.insert(texts, '<layout w="80" h="32" xalign="right" yalign="center">' .. item.durability .. 'term</layout>')
	if tonumber(item.equipped) == 1 then
		table.insert(texts, '<layout w="100" h="32" xalign="right" yalign="center"><col name="blue">()</col></layout>')
	end
	return table.concat(texts)
end
--}}}
--{{{ make_ideal_church_explanation
function make_ideal_church_explanation(item_id)
	local recipe = load_game_data('gamedata.ideal_church_recipe.' .. item_id)
	print_debug(recipe)
	if #recipe == 0 then
		return '̃ACe͐_̗͂͊܂B'
	end
	local texts = {}
	table.insert(texts, get_icon_image_tag(recipe[1].icon_type))
	table.insert(texts, '<layout w="200" h="32" xalign="left" yalign="center">' .. recipe[1].name .. 'Grade' .. recipe[1].grade .. 'ł</layout>')
	return table.concat(texts)
end
--}}}
--{{{ make_shop_item_text
function make_shop_item_text(item)
	local icon = get_icon_image_tag(item.icon_type)
	local text = '<layout w="250" h="32" xalign="left" yalign="center">' .. icon .. item.name .. '</layout>'
	text = text .. '<layout w="50" h="32" xalign="left" yalign="center"><col name="blue">ϐ</col></layout>'
	text = text .. '<layout w="80" h="32" xalign="right" yalign="center">' .. item.durability .. 'term</layout>'
	text = text .. '<layout w="140" h="32" xalign="right" yalign="center">'.. item.price .. 'JEM</layout>'
	return text
end
--}}}
--{{{ service_menu
function service_menu(jem_text, explanation_text, service_id, grade)

	local service_info = load_game_data('gamedata.service_info.' .. service_id .. '.' .. grade)
	if service_info[1].type == 'shop' then
		shop_menu(jem_text, explanation_text, service_id, grade, service_info[1].name)
	elseif service_info[1].type == 'ideal_church' then
		ideal_church_menu(jem_text, explanation_text, service_id, grade, service_info[1].name)
	end
end
--}}}
--{{{ shop_menu
function shop_menu(jem_text, explanation_text, service_id, grade, service_name)

	local answer = 0

	local chara_pic = Picture:new('file.image/shop/bukiya.png')
	local x, y = to_client_coord(0.01, 0.1)
	chara_pic:set_tween('position2', {[0] = {x, y}}, 0)
	chara_pic:set_tween('size2', {[0] = {256 * 0.9, 512 * 0.9}}, 0) -- TODO

	local shop_list = load_game_data('gamedata.shop_list.' .. service_id .. '.' .. grade)
	local items = {}
	for idx, val in ipairs(shop_list) do
		table.insert(items, make_shop_item_text(val))
	end

	explanation_text:next(make_shop_item_explanation(shop_list[1]))

	while true do
		answer = question(service_name, items, 'view=scroll', FeedTween:new(0.3, 0.25, 0.65, 0.4), false,
			function (index)
				explanation_text:next(make_shop_item_explanation(shop_list[index + 1]))
			end)
		break
	end

	chara_pic:dispose()


end
--}}}
--{{{ ideal_church_menu
function ideal_church_menu(jem_text, explanation_text, service_id, grade, service_name)

	local answer = 0

	local chara_pic = Picture:new('file.image/shop/bukiya.png')
	local x, y = to_client_coord(0.01, 0.1)
	chara_pic:set_tween('position2', {[0] = {x, y}}, 0)
	chara_pic:set_tween('size2', {[0] = {256 * 0.9, 512 * 0.9}}, 0) -- TODO

	local items = load_game_data('gamedata.item_profile')
	local menu_items = {}
	local disables = {}
	for idx, val in ipairs(items) do
		if #load_game_data('gamedata.ideal_church_recipe.' .. val.id) == 0 then
			-- ȑI
			table.insert(menu_items, '<col name="gray">' .. make_item_text(val) .. '</col>')
			table.insert(disables, idx - 1)
		else
			table.insert(menu_items, make_item_text(val))
		end
	end
	
	explanation_text:next(make_ideal_church_explanation(items[1].id))

	while true do
		local style = 'view=scroll'
		if #disables ~= 0 then
			style = style .. ';disable=' .. join(disables, ',')
		end
		answer = question(service_name, menu_items, style, FeedTween:new(0.3, 0.25, 0.65, 0.4), false,
			function (index)
				explanation_text:next(make_ideal_church_explanation(items[index + 1].id))
			end)
		break
	end

	chara_pic:dispose()


end
--}}}
