require('script/moflib')
require('script/common')
require('script/stage_menu')
require('script/main_menu')
require('script/land_menu')
require('script/effect')

--{{{ enter_land
function enter_land(area, x, y)
	local answer = question('<font size="20">' .. area.name .. 'K₵܂<nl/>낵łH</font>', 
		{'<layout w="150" h="24" xalign="center">͂</layout>', '<layout w="150" h="24" xalign="center"></layout>'},
		'direction=horizontal;view=no-title-bg', FeedTween:new(0.3, 0.4, 0.4, 0.2), false)
	if answer == 1 then
		land_menu(x, y)
	end
end
--}}}
--{{{ element_menu
function element_menu(area, x, y, cursor)
	local profile = load_game_data('gamedata.main_profile')
	local items = {}
	local disables = {}

	local elements = {
		{'X̃Gg', tonumber(profile[1].forest_element), 'forest'},
		{'ñGg', tonumber(profile[1].earth_element), 'earth'},
		{'̃Gg', tonumber(profile[1].water_element), 'water'},
	}
	for idx, val in ipairs(elements) do
		local text = '<layout w="100" h="24" xalign="left" yalign="center">' .. get_icon_image_tag(val[3]) .. val[1] .. '</layout>'
		text = text .. '<layout w="170" h="24" xalign="right" yalign="center">' .. val[2] .. '</layout>'
		if val[2] ~= 0 then
			table.insert(items, text)
		else
			table.insert(items, '<col name="gray">' .. text .. '</col>')-- GgȂƂ 
			table.insert(disables, idx - 1)
		end
	end

	local style = 'view=no-title-bg'
	if #disables ~= 0 then
		style = style .. ';disable=' .. join(disables, ',')
	end

	local answer = question('<font size="20">' .. area.name .. 'ɃGgzu܂</font>', 
		items, style, FeedTween:new(0.3, 0.4, 0.4, 0.2), false)
	if answer == 1 then
		cursor:set_tween('size3', {[0] = {0.0, 0.0, 0.0}})
		put_element(ELEMENT_TYPE_FOREST, x, y)
		profile[1].forest_element = tonumber(profile[1].forest_element) - 1;
		save_game_data('gamedata.main_profile', profile)
		invoke(forest_element, 0.2 * x + 0.1, 0, -0.2 * y - 0.1)
		wait_frame(150)
		cursor:set_tween('size3', {[0] = {0.2, 0.1, 0.2}, [20] = {0.2, 0.2, 0.2}})
	elseif answer == 2 then
		cursor:set_tween('size3', {[0] = {0.0, 0.0, 0.0}})
		put_element(ELEMENT_TYPE_EARTH, x, y)
		profile[1].earth_element = tonumber(profile[1].earth_element) - 1;
		save_game_data('gamedata.main_profile', profile)
		invoke(earth_element, 0.2 * x + 0.1, 0, -0.2 * y - 0.1)
		wait_frame(150)
		cursor:set_tween('size3', {[0] = {0.2, 0.1, 0.2}, [20] = {0.2, 0.2, 0.2}})
	elseif answer == 3 then
		cursor:set_tween('size3', {[0] = {0.0, 0.0, 0.0}})
		put_element(ELEMENT_TYPE_WATER, x, y)
		profile[1].water_element = tonumber(profile[1].water_element) - 1;
		save_game_data('gamedata.main_profile', profile)
		invoke(water_element, 0.2 * x + 0.1, 0, -0.2 * y - 0.1)
		wait_frame(150)
		cursor:set_tween('size3', {[0] = {0.2, 0.1, 0.2}, [20] = {0.2, 0.2, 0.2}})
	end

end
--}}}
--{{{ forest_already_located
function forest_already_located()
	message('', {get_icon_image_tag('forest') .. 'X̃GgɔzuĂ܂'}, nil, FeedTween:new(0.2, 0.4, 0.6, 0.1))
end
--}}}
--{{{ earth_already_located
function earth_already_located()
	message('', {get_icon_image_tag('earth') .. 'ñGgɔzuĂ܂'}, nil, FeedTween:new(0.2, 0.4, 0.6, 0.1))
end
--}}}
--{{{ water_already_located
function water_already_located()
	message('', {get_icon_image_tag('water') .. '̃GgɔzuĂ܂'}, nil, FeedTween:new(0.2, 0.4, 0.6, 0.1))
end
--}}}
--{{{ update_area
function update_area(cursor, x, y, area_info, area_profile, area_pic)
	cursor:set_tween('position3', {[0] = {0.1 + 0.2 * x, 0.0, -0.1 - 0.2 * y}})
	cursor:set_tween('size3', {[0] = {0.2, 0.1, 0.2}, [20] = {0.2, 0.2, 0.2}})

	local syuzoku = 
		{{'ehves', area_profile.ehves, area_profile.ehves_power},
		{'bolony', area_profile.bolony, area_profile.bolony_power},
		{'stra', area_profile.stra, area_profile.stra_power}}
	

	-- A͒x̂tableōœK
	local buf = {}
	table.insert(buf, '<font size="50" name="Vinque"><layout w="300" h="32" xalign="left" yalign="center"><col code="88eeff">')
	table.insert(buf, area_profile.name .. '</col></layout></font>')
	table.insert(buf, '<layout w="50" h="50" xalign="left" yalign="center">' .. get_icon_image_tag('forest') .. area_profile.forest .. '</layout>')
	table.insert(buf, '<layout w="50" h="50" xalign="left" yalign="center">' .. get_icon_image_tag('earth') .. area_profile.earth .. '</layout>')
	table.insert(buf, '<nl/><font size="14"><layout w="100" h="12" xalign="left" yalign="center">푰z')
	for idx, val in ipairs(syuzoku) do
		table.insert(buf, '<layout w="32" h="12" xalign="left" yalign="top">' .. get_icon_image_tag(val[1]) .. '</layout>')
		table.insert(buf, '<layout w="30" h="12" xalign="right" yalign="center">' .. val[2] .. '%</layout>@@')
	end
	table.insert(buf, '</layout></font>')
	table.insert(buf, '<nl/><font size="14"><layout w="100" h="20" xalign="left" yalign="bottom">푰l@@')
	for idx, val in ipairs(syuzoku) do
		table.insert(buf, '<layout w="32" h="20" xalign="left" > </layout>')
		table.insert(buf, '<layout w="30" h="20" xalign="right" yalign="bottom">' .. val[3] .. '</layout>@@')
	end
	table.insert(buf, '</layout></font>')


	area_info:next(table.concat(buf))

	if area_pic ~= nil then area_pic:dispose() end
	area_pic = Picture:new('file.' .. area_profile.picture)
	local x, y = to_client_coord(0.05, 0.25)
	area_pic:set_tween('position2', {[0] = {x, y}}, 0)
	area_pic:set_tween('size2', {[0] = {256 * 0.7, 512 * 0.7}}, 0)-- GA̍ɂ킹
	return area_pic

end
--}}}
--{{{ area_menu
function area_menu()
	local cursor_x = 0
	local cursor_y = 0


	local s = Solid:new('file.model/area_cursor.x')
	
	local area_info = text('', ' ', 'view=no-title-bg', FeedTween:new(0.05, 0.05, 0.70, 0.15))

	--local prop = area_info:get_properties()
	--local w, h = split(prop['size2'], ',')
	local area = load_game_data('gamedata.area_profile.' .. cursor_x .. '.' .. cursor_y)
	local area_pic = update_area(s, cursor_x, cursor_y, area_info, area[1], nil)
	wait_frame(30)
	local region = nil-- h݂ꍇ̂land region\
	if area[1].land_flag == '1' then region = land_region_create(cursor_x, cursor_y) end

	while true do
		local skip = false
		local k = get_key()
		if k == KEY_X then 
			sound('sound/cancel.wav')
			break
		elseif k == KEY_Z then 
			sound('sound/decide.wav')
			if area[1].forest_flag == '1' then 
				forest_already_located()
			elseif area[1].earth_flag == '1' then 
				earth_already_located()
			elseif area[1].water_flag == '1' then 
				water_already_located()
			elseif area[1].capital_flag == '1' then 
				enter_land(area[1], cursor_x, cursor_y)
			else 
				element_menu(area[1], cursor_x, cursor_y, s)
				area = load_game_data('gamedata.area_profile.' .. cursor_x .. '.' .. cursor_y)-- GAXV
			end
			skip = true
		elseif k == KEY_UP    and cursor_y > 0  then cursor_y = cursor_y - 1 
		elseif k == KEY_DOWN  and cursor_y < 5 then cursor_y = cursor_y + 1 
		elseif k == KEY_LEFT  and cursor_x > 0  then cursor_x = cursor_x - 1 
		elseif k == KEY_RIGHT and cursor_x < 5 then cursor_x = cursor_x + 1 
		else skip = true end

		if not skip then
			sound('sound/select.wav')
			area = load_game_data('gamedata.area_profile.' .. cursor_x .. '.' .. cursor_y)
			area_pic = update_area(s, cursor_x, cursor_y, area_info, area[1], area_pic)
			if region then 
				region:dispose() 
				region = nil
			end
			if area[1].land_flag == '1' then region = land_region_create(cursor_x, cursor_y) end
		end
	end
	s:dispose()
	area_info:dispose()
	area_pic:dispose()
	if region then region:dispose() end
end
--}}}
--{{{ world_menu
function world_menu()

	local camera = Camera:new()
	camera:set_tween('eye', {[0] = {0.6, 1.4, -2.4}})
	camera:set_tween('lookat', {[0] = {0.6, 0, -0.6}})
	wait_frame(1)

	local s = Solid:new('world')
	local world_light = Light:new('directional')
	world_light:set_tween('position3', 
		{
			['loop'] = {0, 2400},
			[0] = {1, -0.1, 0},
			[600] = {0, -0.1, -1},
			[1200] = {-1, -0.1, 0},
			[1800] = {0, -0.1, -1},
			[2400] = {1, -0.1, 0},
		})
	world_light:set_tween('ambient.color', {[0] = {0.5, 0.5, 0.9}})
	world_light:set_tween('diffuse.color', {[0] = {1, 1, 1}})
	s:set_light(world_light)
	local land_names = {}
	for i = 0,5 do
		for j = 0,5 do
			local area = load_game_data('gamedata.area_profile.' .. i .. '.' .. j)
			if area[1].capital_flag == '1' then
				local name = area[1].name
				name = '<col code="000011"><font name="Vinque" size="22"><layout w="50" xalign="center">' .. name .. '</layout></font></col>'
				table.insert(land_names, text('', name, 'view=no-content-bg', LandNameTween:new(0.2 * i, 0.2 * j + 0.05)))
			end
		end
	end

	local world_profile = load_game_data('gamedata.world_profile')
	local saisei_text = '<font id="1" size="30">Term ' .. world_profile[1].term .. '/Đx ' .. world_profile[1].regen .. '</font>'
	local saisei = text('', saisei_text, 'view=no-title-bg', FeedTween:new(0.55, 0.85, 0.4, 0.1))

	-- np֐
	local finalizer = function () 
		for idx, val in ipairs(land_names) do
			val:dispose()
		end
		s:dispose()
		world_light:dispose()
		saisei:dispose()
	end

	local answer = 0
	while true do
		local items = {
			'<layout w="130" h="28" xalign="center" yalign="center"><col name="gray">_W</col></layout>',
			'<layout w="130" h="28" xalign="center" yalign="center">GAj[</layout>',
			'<layout w="130" h="28" xalign="center" yalign="center">X[v</layout>',
			'<layout w="130" h="28" xalign="center" yalign="center">Cj[</layout>',
		}
		local sleep_select = false
		answer = question(make_caption_text('World Menu'), items, 'direction=horizontal;disable=0', FeedTween:new(0.1, 0.05), true, nil,
			function (index)
				if index == 2 then
					local answer = question('<font size="20">1termāÂč\z܂B<nl/>낵łH</font>', 
						{'<layout w="150" h="24" xalign="center">͂</layout>', '<layout w="150" h="24" xalign="center"></layout>'},
						'direction=horizontal;view=no-title-bg', FeedTween:new(0.3, 0.4, 0.4, 0.2), false)
					if answer == 1 then
						-- X[v
						sleep_select = true
						world_sleep()
						return true
					end
					return false
				end
				return true
		end)
		if answer == 1 then
			stage_menu()
		elseif answer == 2 then
			camera:set_tween('eye', {[0] = {0.6, 1.4, -2.4}, [30] = {0.3, 1.4, -2.4}})
			camera:set_tween('lookat', {[0] = {0.6, 0, -0.6}, [30] = {0.3, 0, -0.6}})
			area_menu()
			camera:set_tween('eye', {[0] = {0.3, 1.4, -2.4}, [30] = {0.6, 1.4, -2.4}})
			camera:set_tween('lookat', {[0] = {0.3, 0, -0.6}, [30] = {0.6, 0, -0.6}})
		elseif answer == 4 then
			main_menu()
		end

		if sleep_select then
			-- X[vIĂ甲
			finalizer()
			return
		end

	end

	
	finalizer()
end
--}}}
