#ifndef BILLBOARD_HPP
#define BILLBOARD_HPP

#include "mof/Component3D.hpp"
#include "mof/SceneGraph.hpp"
#include "mof/Rectangle.hpp"
#include "mof/Drawable.hpp"
#include <boost/scoped_ptr.hpp>
#include <memory>
#include "mof/Texture.hpp"

namespace mof{
	

class Camera;

class Board : public Component3D , public Drawable
	{
	struct Impl;
	boost::scoped_ptr<Impl> m_pImpl;

public :
	typedef std::shared_ptr<Board> ptr;
	
	Board( );
	virtual ~Board();

	
	virtual void setWorldMatrix(const mof::Manipulator<mof::Matrix3D>::Handler& handler);
	mof::Matrix3D getWorldMatrix() const;
	mof::Vector3D getPosition() const;
	virtual void setTextureCoordinates(const mof::Manipulator<mof::Rectangle<float>>::Handler& handler);
	virtual void setTextureCoordinates(const mof::Rectangle<float>& coordinates);
	virtual void setTexture( const std::shared_ptr<mof::Texture>& pTexture );

	void setColor(const mof::Manipulator<mof::Color4f>::Handler& handler);

	virtual bool isVisible() const;
	virtual void update();
	virtual void draw() const;
	virtual void setVisible(bool visible);
	void setFrameNumber(FrameNumber fn);
};

}

#endif
