#pragma once
#include "mof/stream/utilities.hpp"

namespace mof
{

    class ColorComponent
    {
    public:
        virtual ~ColorComponent( ){}

        virtual void setColorStream( const ColorStream& stream )
        {
            m_colorStream = stream;
        }

        virtual const ColorStream& getColorStream( ) const
        {
            return m_colorStream;
        }
        
        virtual ColorStream& getColorStream( )
        {
            return m_colorStream;
        }

        
    protected:
        ColorStream m_colorStream;

        ColorComponent( )
        : 
            m_colorStream( makeConstantHandler( Color4f( 1 , 1 , 1 ) ) ) 
        {
        }
        
        ColorComponent( const Color4f& color )
        : 
            m_colorStream( makeConstantHandler( color ) ) 
        {
        }

        ColorComponent( const ColorStream& stream )
        : 
            m_colorStream( stream ) 
        {
        }

    };
} // namespace mof
