#include "mof/KeyPressedEventCondition.hpp"

mof::KeyPressedEventCondition::KeyPressedEventCondition
(
	mof::InputReceiver::Key key, 
	const std::shared_ptr<mof::InputReceiver> &pInputReceiver 
)
: m_key(key) , m_pInputReceiver(pInputReceiver) , m_currentState(false) 
{
	update();
}

mof::KeyPressedEventCondition::~KeyPressedEventCondition(){
}

bool mof::KeyPressedEventCondition::test(){
	return m_oldState == false &&  m_currentState == true ;
}

void mof::KeyPressedEventCondition::update(){
	m_oldState = m_currentState;
	m_currentState = m_pInputReceiver->testKeyState(m_key);
}

bool mof::KeyPressedEventCondition::isDisposable(){
	return false;
}


