#pragma once
#include <iostream>
#include <mof/Vector2D.hpp>

namespace mof
{
	template<typename E>
	struct Rectangle
	{
		E beginX;
		E beginY;
		E endX;
		E endY;

		Rectangle(){}

        template< typename T >
        Rectangle(const Rectangle<T>& obj)
        {   
            beginX = obj.beginX;
            beginY = obj.beginY;
            endX   = obj.endX;
            endY   = obj.endY;
        }

		Rectangle(const E& beginX_ , const E& beginY_ , const E& endX_ , const E& endY_)
			: beginX(beginX_) , beginY(beginY_) , endX(endX_) , endY(endY_)
		{}

        template< typename T >
        Rectangle& operator = ( const Rectangle<T>& obj )
        {   
            beginX = obj.beginX;
            beginY = obj.beginY;
            endX   = obj.endX;
            endY   = obj.endY;
            return *this;
        }

        E getWidth( ) const
        {
            E width = endX - beginX;
            return width < 0 ? -width : width;
        }
        
        E getHeight( ) const
        {
            E height = endY - beginY;
            return height < 0 ? -height : height;
        }

		void setPosition(const Vector2D& position)
		{
			E width = getWidth(); 
			E height = getHeight(); 
			beginX = position.x;
			beginY = position.y;
			endX = width + beginX; 
			endY = height + beginY;
		}

		void setScale(const Vector2D& scale)
		{
			endX = scale.x + beginX;
			endY = scale.y + beginY;
		}
		

		bool operator ==(const mof::Rectangle<E>& rect){
			if(
				beginX == rect.beginX &&
				beginY == rect.beginY &&
				endX == rect.endX &&
				endY == rect.endY )return true;
			else return false;
		}

	
	};

	template<typename E>
	std::ostream& operator <<(std::ostream& os , const mof::Rectangle<E>& rect){
		os << '(' << rect.beginX << ',' << rect.beginY << ','
			<< rect.endX << ',' << rect.endY << ')';
		return os;	
	}
	
}
