#pragma once
#include <boost/scoped_ptr.hpp>
#include "mof/VertexTypes.hpp"
#include <boost/utility.hpp>

namespace mof{



template <class T>
class VertexBuffer : boost::noncopyable{
	
	struct Impl;
	boost::scoped_ptr<Impl> m_pImpl;
public:
	VertexBuffer();

	VertexBuffer
	(
		const T& front , const T& back , 
		mof::PRIMITIVE_TYPE primitiveType = PRIMITIVE_TYPE_TRIANGLELIST 
	);
	~VertexBuffer();

	int getLength() const;
	mof::PRIMITIVE_TYPE getPrimitiveType() const;
	void draw() const;

};

	
}
