#pragma once
#include <mof/Component3D.hpp>
#include <boost/utility.hpp>
#include <memory>
#include <list>

namespace mof
{
	class Board;

	class particlegen : boost::noncopyable
	{
	public:
		typedef std::shared_ptr<particlegen> ptr;

		particlegen();
		virtual ~particlegen();

		const Matrix3DStream& world_transform() const;
		Matrix3DStream& world_transform();
		void update();
		const std::list<Board*>& drawables() const;

	private:
		struct impl;
		std::unique_ptr<impl> pimpl_;
	};


}// namespace mof
