#ifndef MOF_MESH_HPP
#define MOF_MESH_HPP
#include <d3d9.h>
#include "mof/Graphics3D.hpp"
#include <boost/scoped_ptr.hpp>
#include "mof/Material.hpp"
#include "mof/Texture.hpp"

namespace mof{

struct MeshDisposer;

class Mesh : public Graphics3D
{
	struct Impl;
	boost::scoped_ptr<Impl> m_pImpl;

public :
	Mesh(
		std::shared_ptr<mof::MeshDisposer> pMeshDisposer ,
		unsigned long nMaterials ,
		const mof::Material* pMaterials , 
		const std::shared_ptr<mof::Texture>* pTextures );
	virtual ~Mesh();

	virtual void setTexture
	( 
		unsigned int num ,
		const std::shared_ptr<mof::Texture>& pTextures
	);
	
	/*
	virtual void setMaterialBuilder
	( 
		unsigned int num ,
		const std::shared_ptr<mof::MaterialBuilder>& material_builder
	);
	*/



	virtual void setVisible(bool visible);
	virtual void update();
	virtual void draw() const;

};

}

#endif
