#pragma once
#include "mof/tstring.hpp"
#include "mof/InputReceiver.hpp"
#include "mof/script/ObjectData.hpp"
#include <vector>
#include <mof/stream/Manipulator.hpp>
#include <mof/Color.hpp>
#include <mof/Vector2D.hpp>
#include <mof/Vector3D.hpp>
	
namespace mof
{
namespace script
{

	class CommandSet
	{
	public:
		enum MoveDirection
		{
			MOVE_UP = 0,
			MOVE_DOWN,
			MOVE_LEFT,
			MOVE_RIGHT,
		};

		enum ElementType
		{
			FOREST = 0,
			EARTH,
			WATER
		};


		/** 
		 * @brief	 bZ[WEBhE𐶐邽߂̃R[obN
		 * @return	bZ[WEBhE
		 */
		virtual int message_create(const mof::tstring& title, const GameData::entry_t& style) = 0;
	
		virtual int menu_create(const mof::tstring& title, const std::vector<mof::tstring>& items, const GameData::entry_t& style) = 0;
		
		virtual int vertex_buffer_create
		(
			const mof::VertexXYZRHWCUV& front,
			const mof::VertexXYZRHWCUV& back,
			const mof::Texture::ptr& texture
		) = 0;

		virtual int sound_create(const mof::tstring& filepath) = 0;
		
		virtual void sound_play(int id) = 0;
		
		virtual int picture_create(const mof::tstring& filepath) = 0;
		
		virtual int camera_create() = 0;
		
		virtual int particlegen_create() = 0;
		
		virtual int solid_create(const mof::tstring& class_path) = 0;
		
		virtual int light_create(const mof::tstring& class_path) = 0;
		
		virtual void set_light(int id, int light_id) = 0;
		
		virtual int board_create(const mof::tstring& filepath) = 0;

		/** 
		 * @brief	 bZ[WEBhEɃy[Wǉ邽߂̃R[obN
		 * @param[in] bZ[W̃^Cg
		 * @param[in] bZ[We
		 * @return	bZ[WEBhE
		 */
		virtual int message_next(int id, const tstring& text) = 0;
	   
		virtual void wait_for_key(size_t id, mof::InputReceiver::Key key) = 0;
		
		virtual mof::InputReceiver::Key get_last_key() = 0;
		
		virtual void wait_frame(size_t id, size_t frame) = 0;
		
		virtual bool is_waiting(size_t id) const = 0;

		virtual int menu_move_cursor(int id, MoveDirection direction) = 0;
		
		virtual int menu_select(int id) = 0;
		
		virtual int menu_get_current(int id) = 0;
		
		virtual GameData::ptr load_game_data(const mof::tstring& resource_path) = 0;
		
		virtual void save_game_data(const mof::tstring& resource_path, const GameData::ptr& game_data) = 0;

		virtual void print_debug(const mof::tstring& message) = 0;
		
		// ʂ̃\bh
		virtual int show(int id, const mof::tstring& class_path) = 0;
		
		virtual int hide(int id, const mof::tstring& class_path) = 0;
		
		virtual void dispose(int id, const mof::tstring& class_path) = 0;
		
		virtual GameData::ptr get_properties(int id, const mof::tstring& class_path) = 0;

		/**
		 * @brief IuWFNgɃrwCrAݒ
		 * @param[in] id     IuWFNgID
		 * @param[in] target ^[Qbgʖ
		 * @param[in] seq    w肷V[PX
		 * @param[in] period V[PX̃sIh
		 */
		virtual void set_color_behavior(int id, const mof::tstring& class_path, const Manipulator<Color4f>::ptr& seq, FrameNumber period) = 0;
		
		virtual void set_position_behavior(int id, const mof::tstring& class_path, const Manipulator<Vector2D>::ptr& seq, FrameNumber period) = 0;
		
		virtual void set_position_behavior(int id, const mof::tstring& class_path, const Manipulator<Vector3D>::ptr& seq) = 0;
		
		virtual void set_camera_behavior(int id, const mof::tstring& class_path, const Manipulator<Vector3D>::ptr& seq) = 0;
		
		virtual void set_size_behavior(int id, const mof::tstring& class_path, const Manipulator<Vector2D>::ptr& seq, FrameNumber period) = 0;
		
		virtual void set_size_behavior(int id, const mof::tstring& class_path, const Manipulator<Vector3D>::ptr& seq) = 0;

		virtual void set_texture_coord_tween
		(
			int id,
			const mof::tstring& class_path, 
			const Manipulator<mof::Rectangle<float>>::ptr& seq
		) = 0;

		// ApplicationɈˑR}h(TODO moflibrdg)
		virtual mof::frame_t put_element(ElementType type, int x, int y) = 0;
		virtual void world_sleep() = 0;
		
		virtual int land_region_create(int x, int y) = 0;
		
		virtual ~CommandSet(){}

	};

}
}

