#include <lua.hpp>
#include "luabind/luabind.hpp"
#include <memory>
#include <boost/utility.hpp>
#include <boost/function.hpp>

// LuaInterpreter.cppからのみインクルードする

namespace mof
{
namespace script
{
	class CommandSet;

	class lua_state : boost::noncopyable
	{
	public:
		~lua_state();
		typedef boost::function<size_t (lua_State*)> callback_invoke_t; 
		void bind(std::shared_ptr<mof::script::CommandSet> commands, const callback_invoke_t& callback_invoke);
		lua_State* raw_lua() const;
		std::shared_ptr<mof::script::CommandSet>& const command_set() const;
		size_t invoke(lua_State* th);
		static lua_state& instance(); 
		void set_target_thread_id(size_t id);
		size_t get_target_thread_id() const;
	private:
		lua_state();// singleton
		static lua_state singleton_lua;
		struct Impl;
		std::unique_ptr<Impl> impl_;
	};

}// script
}// mof
