#pragma once
#include "mof/stream/Manipulator.hpp"
#include <mof/Vector2D.hpp>
#include <mof/GraphicsDevice.hpp>


namespace mof
{

    class world2client_tween : public Manipulator<Vector2D>
    {
	    
    public:
		typedef std::shared_ptr<world2client_tween> Handler;
		typedef std::shared_ptr<world2client_tween> ptr; 


    	virtual mof::Vector2D value(frame_t frame) const
        {
			return mof::GraphicsDevice::to2DPosition(m_pBody->value(frame));
	    }


		world2client_tween(const Manipulator<Vector3D>::Handler& pBody)
	    	: m_pBody(pBody) 
	    {
	    }
        
		virtual ~world2client_tween(){}	

    private:
        Manipulator<Vector3D>::Handler m_pBody;

    };
} //namespace mof

