#pragma once
#include "mof/widget/AbstractTextCompiler.hpp"
#include "boost/scoped_ptr.hpp"
#include "boost/function.hpp"
#include <mof/Texture.hpp>

namespace mof
{
    class Font;
namespace widget
{

    class TextCompiler : public AbstractTextCompiler
    {
    public:
        TextCompiler(const mof::Font& font);
        TextCompiler(const mof::Font& font, const boost::function<mof::Texture::ptr (const mof::tstring&)>& factory);
        virtual ~TextCompiler();
		virtual void set_texture_factory(const boost::function<mof::Texture::ptr (const mof::tstring&)>& factory);
		virtual std::auto_ptr<mof::widget::WidgetView> compile(const mof::tstring& text);
		virtual void setBehaviorOnPosition(BehaviorTarget target, mof::Manipulator<mof::Vector2D>::Handler position, FrameNumber period);
		virtual void setBehaviorOnColor(BehaviorTarget target, mof::Manipulator<mof::Color4f>::Handler color, FrameNumber period);

    private:
        struct Impl;
        boost::scoped_ptr<Impl> pImpl_;
    };//class TextCompiler 

}// namespace widget
}// namespace mof
