#pragma once
#include "mof/Component2D.hpp"
#include "mof/ColorComponent.hpp"
#include "mof/Drawable.hpp"
#include <memory>

namespace mof
{
namespace widget
{

	class WidgetView  
    :
        public Component2D ,
        public ColorComponent ,
        public Drawable 
    {
	public:
		typedef std::shared_ptr<WidgetView> ptr;
		virtual ~WidgetView(){};

		// TODO CAEg̃AjƃCxg̃AjAꂼǂłǂ̂悤ɐݒ肷邩
		// TODO GtFNgOݒł悤ɂ
		// TODO ȃR|[lgOݒł悤
		// TODO XvCg͂ǂ
        virtual FrameNumber show( bool imidiately = false ) = 0; 
        virtual FrameNumber hide( bool imidiately = false ) = 0;
        virtual FrameNumber focus( bool imidiately = false ) = 0; 
        virtual FrameNumber blur( bool imidiately = false ) = 0;
        virtual FrameNumber click( bool imidiately = false ) = 0;

		/**
		 * ̃IuWFNg鏉TCY
		 */
		virtual mof::Vector2D getPreferredSize() const = 0;

		virtual void update() = 0;
		virtual void draw() const = 0;
		virtual void setVisible(bool visible) = 0;
	};

}
}
