#pragma once
#include <mof/math/basic_matrix.hpp>

namespace mof
{
namespace math
{
	class vector2;

	/**
	 * @brief 2次元同次座標変換行列クラス
	 */
	class matrix2 : public basic_matrix<2, matrix2, vector2>
	{
	public:
//{{{ constructor
		/**
		 * @brief デフォルトコンストラクタ
		 * @note  効率のため，初期化は行われない
		 */
		matrix2()
		{
		}

		/**
		 * @brief 指定した値で初期化する．
		 * @tparam     T   配列型（operator[]をオーバーロードしていること）
		 * @param[in]  arr 初期化用配列
		 */
		template <class T>
		explicit matrix2(const T& arr)
		{
			for (size_t i = 0; i < size(); ++i) {
				elements_[i] = arr[i];
			}
		}
		
		/**
		 * @brief 指定した値で初期化する．
		 */
		matrix2
		(
			float m11, float m12, float m13,
			float m21, float m22, float m23
		)
		{
			const float* table[] =
				{
					&m11, &m12, &m13,
					&m21, &m22, &m23
				};
			for (size_t i = 0; i < size(); ++i) {
				elements_[i] = *table[i];
			}
		}

//}}}
//{{{ copy constructor
	matrix2(const matrix2& rhs)
	{
		for (size_t i = 0; i < size(); ++i) {
			elements_[i] = rhs.elements_[i];
		}
	}
//}}}
//{{{ operator =
	matrix2& operator = (const matrix2& rhs)
	{
		for (size_t i = 0; i < size(); ++i) {
			elements_[i] = rhs.elements_[i];
		}
		return *this;
	}
//}}}
	};

}// namespace math
}// namespace mof
