#include <mof/math/vector2.hpp>
#include <iostream>
#include <sstream>

int main()
{
	using namespace mof::math;
	using namespace std;
	vector2 v;
	int failed_count = 0;

	v = vector2(1, 2);
	if (v[0] != 1 || v[1] != 2 || v[2] != 1) {
		cerr << "Failed:" << " initialize by array" << endl;	
		failed_count++;
	}

	// any operations keeps the last component 1
	v = vector2(1, 2);
	vector2 w(3, 4);
	v = v + w;
	if (v.x() != 4 || v.y() != 6 || v.z() != 1) {
		cerr << "Failed:" << " addition test" << endl;	
		failed_count++;
	}

	v = vector2(50, 50);
	w = vector2(1, 2);
	v = v - w;
	if (v.x() != 49 || v.y() != 48 || v.z() != 1) {
		cerr << "Failed:"  << " subtraction test" << endl;	
		failed_count++;
	}
	
	v = vector2(10, 10);
	v = 2 * v * 3;
	if (v.x() != 60 || v.y() != 60 || v.z() != 1) {
		cerr << "Failed:"  << " multiplation with scalar test" << endl;	
		failed_count++;
	}
	
	v = vector2(60, 30);
	v = v / 3;
	if (v.x() != 20 || v.y() != 10 || v.z() != 1) {
		cerr << "Failed:"  << " devidation with scalar test" << endl;	
		failed_count++;
	}


	v = vector2(1, 2);
	w = vector2(1, 2);
	if (v != w) {
		cerr << "Failed:" << " comparation test" << endl;	
		failed_count++;
	}
	
	v = vector2(1, 2);
	w = vector2(2, 1);
	if (v == w) {
		cerr << "Failed:" << " comparation test" << endl;	
		failed_count++;
	}

	v = vector2(1, 2);
	w = vector2(3, 4);
	swap(v, w);
	if (v.x() != 3 || v.y() != 4 || w.x() != 1 || w.y() != 2) {
		cerr << "Failed:" << " swap test" << endl;	
		failed_count++;
	}
	return failed_count;
}
