#include <mof/math/vector3.hpp>
#include <iostream>

int main()
{
	using namespace mof::math;
	using namespace std;
	vector3 v;
	int failed_count = 0;

	v = vector3(1, 2, 3);
	if (v[0] != 1 || v[1] != 2 || v[2] != 3 || v[3] != 1) {
		cerr << "Failed:" << " initialize by array" << endl;	
		failed_count++;
	}

	// any operations keeps the last component 1
	v = vector3(1, 2, 3);
	vector3 w(4, 5, 6);
	v = v + w;
	if (v.x() != 5 || v.y() != 7 || v.z() != 9 || v.w() != 1) {
		cerr << "Failed:" << " addition test" << endl;	
		failed_count++;
	}

	v = vector3(1, 2, 3);
	w = vector3(4, 15, 26);
	v = v - w;
	if (v.x() != -3 || v.y() != -13 || v.z() != -23 || v.w() != 1) {
		cerr << "Failed:" << " subtraction test" << endl;	
		failed_count++;
	}
	
	v = vector3(1, 2, 3);
	v = 2 * v * 3;
	if (v.x() != 6 || v.y() != 12 || v.z() != 18 || v.w() != 1) {
		cerr << "Failed:" << " multiplation with scalar test" << endl;	
		failed_count++;
	}
	
	
	v = vector3(90, 60, 30);
	v = v / 3;
	if (v.x() != 30 || v.y() != 20 || v.z() != 10 || v.w() != 1) {
		cerr << "Failed:"  << " devidation with scalar test" << endl;	
		failed_count++;
	}


	v = vector3(1, 2, 3);
	w = vector3(1, 2, 3);
	if (v != w) {
		cerr << "Failed:" << " comparation test" << endl;	
		failed_count++;
	}
	
	v = vector3(1, 2, 3);
	w = vector3(3, 2, 1);
	if (v == w) {
		cerr << "Failed:" << " comparation test" << endl;	
		failed_count++;
	}

	v = vector3(1, 2, 3);
	w = vector3(4, 5, 6);
	swap(v, w);
	if (v.x() != 4 || v.y() != 5 || v.z() != 6 || w.x() != 1 || w.y() != 2 || w.z() != 3) {
		cerr << "Failed:" << " swap test" << endl;	
		failed_count++;
	}

	return failed_count;
}
