#pragma once
#include <memory>
#include <boost/utility.hpp>

namespace mof
{
namespace util
{

	/**
	 * @brief システムのタイマによる高精度な時間計測
	 * @note Linux版の実装ではclock_gettimeのCLOCK_REALTIMEが用いられている．
	 */
    class multimedia_timer : boost::noncopyable
    {
        struct impl;
        std::unique_ptr<impl> pimpl_;
    public:
//{{{ constructor
		/**
		 * @brief デフォルトコンストラクタ．内部でreset()が呼ばれる．
		 */
        multimedia_timer();
//}}}
//{{{ destructor
        ~multimedia_timer();
//}}}
//{{{ reset
		/**
		 * @brief 時間の計測を初期化する．
		 * @sa get_time_in_micro_sec
		 */
        void reset();
//}}}
//{{{ get_time_in_micro_sec
		/**
		 * @brief 最後にreset()を読んだ時点から現在までの経過時間をマイクロ秒単位で返す
		 * @note 経過時間が長時間だった場合、返却値はオーバーフローしている可能性がある．
		 * @retval 経過時間(マイクロ秒単位)
		 */
        int get_time_in_micro_sec() const; 
//}}}
    };

}// namespace util
}// namespace mof
