#include <mof/util/multimedia_timer.hpp>
#include <windows.h>
#include <iostream>


namespace mof
{
namespace util
{
//{{{ impl
    struct multimedia_timer::impl
    {
		LARGE_INTEGER start_time_;
		double frequency_;
    };
//}}}
//{{{ constructor
    multimedia_timer::multimedia_timer()
    : pimpl_(new impl)
    {
		LARGE_INTEGER frequency;// count per sec
		QueryPerformanceFrequency(&frequency);
		pimpl_->frequency_ = static_cast<double>(frequency.QuadPart) / 1000000;// count per micro sec
        reset();
    }
//}}}
//{{{ destructor
    multimedia_timer::~multimedia_timer(){}
//}}}
//{{{ reset
    void multimedia_timer::reset()
    {
		QueryPerformanceCounter(&pimpl_->start_time_);
    }
//}}}
//{{{ get_time_in_micro_sec
    int multimedia_timer::get_time_in_micro_sec() const
    {
		LARGE_INTEGER current_time;
		QueryPerformanceCounter(&current_time);
		double span = static_cast<double>(current_time.QuadPart - pimpl_->start_time_.QuadPart) / pimpl_->frequency_;
		return static_cast<int>(span);
    }
//}}}

}// namespace util
}// namespace mof

