#pragma once
#include "mof/widget/WidgetView.hpp"
#include "mof/FactoryMethod.hpp"
#include "mof/graphics/utilities.hpp"
#include "mof/widget/utilities.hpp"
#include <memory>


class ImageTileView  : public mof::widget::WidgetView
{
public:
	ImageTileView( const std::shared_ptr<mof::Texture>& pTexture );
	virtual ~ImageTileView( );

    virtual mof::FrameNumber show( bool imidiately = false );
    virtual mof::FrameNumber hide( bool imidiately = false );
    virtual mof::FrameNumber focus( bool imidiately = false );
    virtual mof::FrameNumber blur( bool imidiately = false );
    virtual mof::FrameNumber click( bool imidiately = false );
	virtual mof::Vector2D getPreferredSize() const;
    virtual void update( );
    virtual void draw( ) const;
    virtual void setVisible(bool visible);

private:
    struct Impl;
	std::unique_ptr<Impl> m_pImpl;
	
};

