#{{{ mof_executable_project
macro(mof_executable_project exename)
	parse_arguments(THIS_PROJECT "SRCDIRS;LIBRARIES" "" ${ARGN})
	set(CMAKE_RUNTIME_OUTPUT_DIRECTORY ${MOFLIB_BIN_DIR} )
	foreach (srcdir ${THIS_PROJECT_SRCDIRS})	
		file(GLOB tmp FILES "${srcdir}/*.cc")
		list(APPEND srcfiles ${tmp})
		file(GLOB tmp FILES "${srcdir}/*.cpp")
		list(APPEND srcfiles ${tmp})
		file(GLOB tmp FILES "${srcdir}/*.c")
		list(APPEND srcfiles ${tmp})
		file(GLOB tmp FILES "${srcdir}/*.h")
		list(APPEND srcfiles ${tmp})
		file(GLOB tmp FILES "${srcdir}/*.hpp")
		list(APPEND srcfiles ${tmp})
	endforeach ()
	add_executable(${exename} ${srcfiles})
	target_link_libraries(${exename} ${THIS_PROJECT_LIBRARIES})
endmacro()
#}}}
#{{{ mof_library_project
macro(mof_library_project libname)
	parse_arguments(THIS_PROJECT "SRCDIRS" "" ${ARGN})	
	set(CMAKE_ARCHIVE_OUTPUT_DIRECTORY ${MOFLIB_ARCHIVE_DIR} )
	foreach (srcdir ${THIS_PROJECT_SRCDIRS})	
		file(GLOB tmp FILES "${srcdir}/*.cc")
		list(APPEND srcfiles ${tmp})
		file(GLOB tmp FILES "${srcdir}/*.c")
		list(APPEND srcfiles ${tmp})
		file(GLOB tmp FILES "${srcdir}/*.cpp")
		list(APPEND srcfiles ${tmp})
		file(GLOB tmp FILES "${srcdir}/*.h")
		list(APPEND srcfiles ${tmp})
		file(GLOB tmp FILES "${srcdir}/*.hpp")
		list(APPEND srcfiles ${tmp})
	endforeach ()
	add_library(${libname} STATIC ${srcfiles})
endmacro()
#}}}
#{{{ mof_test_run
macro(mof_test_run testname testfile)
	parse_arguments(THIS_PROJECT "LIBRARIES" "" ${ARGN})	
	if (${MOFLIB_BUILD_TESTS})
		set(CMAKE_RUNTIME_OUTPUT_DIRECTORY ${MOFLIB_TESTBIN_DIR})	
		add_executable(${testname} ${testfile})
		target_link_libraries(${testname} ${THIS_PROJECT_LIBRARIES})
		add_test(${testname} ${MOFLIB_TESTBIN_DIR}/${testname}${TEST_BIN_POSTFIX})
	endif ()
endmacro()
#}}}
