#ifndef BILLBOARD_HPP
#define BILLBOARD_HPP

#include "mof/Component3D.hpp"
#include "mof/SceneGraph.hpp"
#include "mof/Rectangle.hpp"
#include "mof/Drawable.hpp"
#include <boost/scoped_ptr.hpp>
#include <memory>
#include "mof/Texture.hpp"
#include "mof/ColorComponent.hpp"
#include "mof/TextureComponent.hpp"

namespace mof{
	class Font;	

class Camera;

	class Board 
		: public Component3D,
		  public ColorComponent,
          public TextureComponent,
		  public Drawable
	{
		struct Impl;
		boost::scoped_ptr<Impl> m_pImpl;

	public :
		typedef std::shared_ptr<Board> ptr;
		
		Board();
		virtual ~Board();

		virtual void setTexture( const std::shared_ptr<mof::Texture>& pTexture );
		virtual bool isVisible() const;
		virtual void update();
		virtual void draw() const;
		virtual void setVisible(bool visible);

		//! テキストを表示するボードを作成する
		static std::unique_ptr<Board> create_text_board(const Font& font, const tstring& text);
	};

}

#endif
