#include "mof/DirectionalLight.hpp"
#include <d3dx9.h>
#include "mof/GraphicsDevice.hpp"
#include "mof/private/GraphicsDeviceImpl.hpp"

mof::DirectionalLight::DirectionalLight()
: mof::Light()
{
	setDiffuseColor(mof::createColor(255, 255, 255));
	setAmbientColor(mof::createColor(0, 0, 0));
	setDirection(mof::makeConstantHandler(mof::Vector3D(0, 0, 0)));
	frame_direction_ = 0;
	reflect();

}


mof::DirectionalLight::DirectionalLight(mof::Color diffuse , mof::Color ambient , mof::Vector3D& direction)
: mof::Light()
{
	setDiffuseColor(diffuse);
	setAmbientColor(ambient);
	setDirection(mof::makeConstantHandler(direction));
	frame_direction_ = 0;
	reflect();

}


void mof::DirectionalLight::update(){
	//mof::Animation* pAnimation = getAnimation();
	//if(pAnimation == NULL)return;
	//pAnimation->update();
	//mof::Color color = pAnimation->get();
	//set(pAnimation->getColor());
	frame_direction_++;
}

void mof::DirectionalLight::reflect(){
	LPDIRECT3DDEVICE9 pDevice = mof::GraphicsDevice::getRawDevice();
	D3DLIGHT9 light;
	ZeroMemory(&light , sizeof(light));
	light.Type = D3DLIGHT_DIRECTIONAL;
	light.Diffuse.a = (float)mof::getAlpha(m_diffuse) / 255.0f;
	light.Diffuse.r = (float)mof::getRed(m_diffuse) / 255.0f;
	light.Diffuse.g = (float)mof::getGreen(m_diffuse) / 255.0f;
	light.Diffuse.b = (float)mof::getBlue(m_diffuse) / 255.0f;

	light.Ambient.a = (float)mof::getAlpha(m_ambient) / 255.0f;
	light.Ambient.r = (float)mof::getRed(m_ambient) / 255.0f;
	light.Ambient.g = (float)mof::getGreen(m_ambient) / 255.0f;
	light.Ambient.b = (float)mof::getBlue(m_ambient) / 255.0f;

	mof::Vector3D direction = m_direction->value(frame_direction_);
	light.Direction = D3DXVECTOR3(direction.x , direction.y , direction.z);
	
	
	pDevice->SetLight(0 , &light);
	pDevice->LightEnable(0 , TRUE);
}

void mof::DirectionalLight::setEnable(bool enable)
{
	// TODO
	reflect();
}

