#include "mof/Font.hpp"
#include <list>
#include <windows.h>
#include "mof/ConsoleIO.hpp"
#include <vector>
#include "mof/utilities.hpp"

#pragma comment(lib, "gdi32.lib")

const TCHAR* mof::Font::MS_GOTHIC = _T("lr SVbN");
const TCHAR* mof::Font::MS_P_GOTHIC = _T("lr oSVbN");


namespace
{
    struct FontManager 
    {
        std::vector<mof::tstring> additionalFontResources;
        
        ~FontManager()
        {
            foreach( mof::tstring& filename , additionalFontResources )
            {
                RemoveFontResource( filename.c_str() );
            }
        }
    } g_fontManager;
}

struct GlyphData{
    int iOfs_x , iOfs_y , iBmp_w , iBmp_h , level , width;
    BYTE* pBmpBuffer;
    bool valid;

   GlyphData(GLYPHMETRICS& GM , TEXTMETRIC& TM , int _level , int bufSize){
        iOfs_x = GM.gmptGlyphOrigin.x;
        iOfs_y = TM.tmAscent - GM.gmptGlyphOrigin.y;
        iBmp_w = GM.gmBlackBoxX + (4-(GM.gmBlackBoxX%4))%4;
        iBmp_h = GM.gmBlackBoxY;
        level = _level;
        width =  GM.gmCellIncX;
        pBmpBuffer = new BYTE[bufSize];
        valid = true;
   }

   ~GlyphData(){
        delete[] pBmpBuffer;
   }
};

struct mof::Font::Impl{
    HFONT hFont;
    size_t fontSize;
	mof::tstring font_name_;
	mof::font_context context_;

    Impl(const TCHAR* font_name, size_t fontSize_, const mof::font_context& context)
        : font_name_(font_name), hFont(NULL) ,fontSize(fontSize_), context_(context)
    {
    }

    ~Impl(){
        DeleteObject(hFont);
    }

};

mof::Font::Font(const TCHAR* fontName , size_t size)
: m_pImpl(new Impl(fontName, size, mof::font_context()))
{
    LOGFONT lf = {m_pImpl->fontSize , 0, 0, 0, FW_REGULAR, 0, 0, 0, DEFAULT_CHARSET, OUT_DEFAULT_PRECIS,
        CLIP_DEFAULT_PRECIS , DEFAULT_QUALITY, DEFAULT_PITCH, "" };
    strcpy_s(lf.lfFaceName , fontName );

    if(!(m_pImpl->hFont = CreateFontIndirect(&lf))){
       throw std::runtime_error("Failed --- CreateFontIndirect");
    }
}


mof::Font::Font(const TCHAR* fontName , size_t size, const mof::font_context& context)
: m_pImpl(new Impl(fontName, size, context))
{
    //LOGFONT lf = {m_pImpl->fontSize , 0, 0, 0, FW_BOLD, 0, 0, 0, DEFAULT_CHARSET, OUT_DEFAULT_PRECIS,
    LOGFONT lf = {m_pImpl->fontSize , 0, 0, 0, FW_REGULAR, 0, 0, 0, DEFAULT_CHARSET, OUT_DEFAULT_PRECIS,
        CLIP_DEFAULT_PRECIS , DEFAULT_QUALITY, DEFAULT_PITCH, "" };
    strcpy_s(lf.lfFaceName , fontName );

    if(!(m_pImpl->hFont = CreateFontIndirect(&lf))){
       throw std::runtime_error("Failed --- CreateFontIndirect");
    }
}

mof::Font::~Font(){
    
}

mof::tstring mof::Font::name() const { return m_pImpl->font_name_; }
size_t mof::Font::size() const { return m_pImpl->fontSize; }
mof::font_context mof::Font::context() const { return m_pImpl->context_; }

//{{{ copy_bitmap
// TODO Yɕ`ł悤ɂ
void copy_bitmap
(
	const std::list<GlyphData*>& glyph_list,
	mof::PixelMap* output,
	mof::Color4f color,
	int offset_x,
	int offset_y,
	int sumWidth,
	int maxHeight
)
{
	using namespace mof;

	int hoseiX = 0;
    typedef std::list<GlyphData*>::const_iterator GDITR;
	color.alpha = 0;
	mof::Color code = color.toColorCode();
    for(GDITR itr = glyph_list.begin() ; itr != glyph_list.end() ; ++itr){
       for(int y = (*itr)->iOfs_y;  y < (*itr)->iOfs_y + (*itr)->iBmp_h;  y++){
            if(!(*itr)->valid)break;//󔒕Ȃ珑݂𖳎
            for(int x = (*itr)->iOfs_x + hoseiX ; x < (*itr)->iOfs_x + (*itr)->iBmp_w + hoseiX && x < sumWidth ;  x++){
				if (x + offset_x < 0 || y + offset_y < 0 || x + offset_x >= sumWidth || y + offset_y >= maxHeight)
				{
					continue;
				}
              	Color src_color = (*output)[x + offset_x][y + offset_y];
                DWORD Alpha = (255 * (*itr)->pBmpBuffer[x - ((*itr)->iOfs_x + hoseiX) + (*itr)->iBmp_w * ( y - (*itr)->iOfs_y ) ] ) / ((*itr)->level-1);
				Color dst_color = code | (Alpha<<24);

				if(getAlpha(src_color) > 0 && getAlpha(dst_color) < 255)
				{
					// ɏ܂ĂAuh
					float rate = static_cast<float>(getAlpha(dst_color)) / (getAlpha(src_color) + getAlpha(dst_color));
					dst_color = blendColor( dst_color, src_color, rate);
					ColorChannel alpha = getAlpha(src_color) < getAlpha(dst_color)? getAlpha(dst_color) : getAlpha(src_color);
					dst_color = createColor(alpha, getRed(dst_color), getGreen(dst_color), getBlue(dst_color));
				}
                
              	(*output)[x + offset_x][y + offset_y] = dst_color;
                
            }
       }
       hoseiX += (*itr)->width;
   }

}
//}}}
//{{{ createText
mof::PixelMap* mof::Font::createText(const mof::tstring& text) const{
	// ڃeNX`̃|C^擾ď߂΂EEE

    // foCXReLXg擾
    // foCXɃtHgȂGetGlyphOutline֐̓G[ƂȂ
    HDC hdc = GetDC(NULL);
    HFONT oldFont = static_cast<HFONT>(SelectObject(hdc , m_pImpl->hFont));
    TEXTMETRIC TM;
    GetTextMetrics( hdc, &TM );

    int sumWidth = 0;
    int maxHeight = 0;
    typedef std::list<GlyphData*>::iterator GDITR;
    std::list<GlyphData*> glyphDataList;
    for(int i = 0 ; text.c_str()[i] ; ){


        // R[h擾
        UINT code = 0;
        #if _UNICODE
            // unicodȅꍇAR[h͒PɃChUINTϊł
            code = (UINT)str[i++];
        #else
            // }`oCg̏ꍇA
            // 1oCg̃R[h1oCgڂUINTϊA
            // 2oCg̃R[h[擱R[h]*256 + [R[h]ł
            if(IsDBCSLeadByte(text[i])){
                code = (text[i] << 8) | (text[i+1] & 0xff); // 
                code &= 0x0000ffff;
                i += 2;
            }
            else{
                code = text[i++];
            }
        #endif

        unsigned int spaceCode = (_T(" ")[0]);
        unsigned int wSpaceCode = (_T("@")[0] << 8) | (_T("@")[1] & 0xff);
        wSpaceCode &= 0x0000ffff;

        // tHgrbg}bv擾
        GLYPHMETRICS GM;
		ZeroMemory(&GM, sizeof(GM));
        CONST MAT2 Mat = {{0,1},{0,0},{0,0},{0,1}};
        DWORD size = GetGlyphOutline(hdc, code , GGO_GRAY8_BITMAP, &GM, 0, NULL, &Mat);
		if (size == GDI_ERROR) throw std::runtime_error("failed: GetGlyphOutline");
        GlyphData* pGD = new GlyphData(GM , TM , 65 , size);
        GetGlyphOutline(hdc, code, GGO_GRAY8_BITMAP, &GM, size, pGD->pBmpBuffer , &Mat);

        if(code == spaceCode || code == wSpaceCode){
            //󔒂͉̂܂߂ȂƂւ̑Ώ
            pGD->valid = false;
        }
        glyphDataList.push_back(pGD);
        sumWidth += pGD->width;//Ŝ̕
        maxHeight = max(maxHeight , TM.tmHeight);
    }

    
    // foCXReLXgƃtHgnh̊J
    SelectObject(hdc, oldFont);
    ReleaseDC(NULL, hdc);

    typedef mof::PixelMap::size_type size_type;
    boost::array<size_type , 2> sizes = {{ sumWidth , maxHeight }};
    mof::PixelMap* pPixelMap = new mof::PixelMap(sizes);

    // tHg̏
    // iOfs_x, iOfs_y : oʒu()
    // iBmp_w, iBmp_h : tHgrbg}bv̕
    // Level : l̒iK (GGO_GRAY4_BITMAPȂ̂17iK)

	// ŃNA
    for(int y = 0 ; y < maxHeight ; y++){
        for(int x = 0 ; x < sumWidth ; x++){
            (*pPixelMap)[x][y] = 0;
        }
    }

	if( 0 != m_pImpl->context_.edge )
	{
		// edge  1 ȏł΁A肷

		unsigned int edge = m_pImpl->context_.edge;
		Color4f edge_color(1, 1, 1);// TODO GbWJ[͍͌Œ
		copy_bitmap(glyphDataList, pPixelMap, edge_color, -edge, 0, sumWidth, maxHeight);
		copy_bitmap(glyphDataList, pPixelMap, edge_color, edge, 0, sumWidth, maxHeight);
		copy_bitmap(glyphDataList, pPixelMap, edge_color, 0, -edge, sumWidth, maxHeight);
		copy_bitmap(glyphDataList, pPixelMap, edge_color, 0, edge, sumWidth, maxHeight);
	}
	copy_bitmap(glyphDataList, pPixelMap, context().font_color, 0, 0, sumWidth, maxHeight);

    for(GDITR itr = glyphDataList.begin() ; itr != glyphDataList.end() ; ++itr){
       delete *itr;
   }

    return pPixelMap;
}
//}}}

bool mof::Font::addFontResource(const mof::tstring& filename ){
    g_fontManager.additionalFontResources.push_back(filename);
    return AddFontResource( filename.c_str() ) ? true : false ;
}
