#pragma once
#include "mof/Rectangle.hpp"
#include <memory>
#include "mof/Texture.hpp"
#include "mof/VertexTypes.hpp"
#include "mof/stream/Manipulator.hpp"
#include "mof/Matrix2D.hpp"
#include "mof/Component2D.hpp"
#include "mof/ColorComponent.hpp"
#include "mof/TextureComponent.hpp"
#include "mof/Drawable.hpp"
#include <vector>


namespace mof{
	
	class Font;

	class Sprite
    : 
        public Component2D ,
        public ColorComponent ,
        public TextureComponent ,
        public Drawable
    {

	public : 
		typedef std::shared_ptr<Sprite> ptr;

		Sprite
        (
			const Rectangle<int>& rect ,
			const std::shared_ptr<Texture>& pTexture ,
			const Rectangle<real>& tRect
		);

		Sprite
        (
			const std::shared_ptr<Texture>& pTexture ,
			const Rectangle<real>& tRect
    	);

		virtual ~Sprite();
		virtual void update();
		virtual void draw() const;
		virtual void setVisible(bool visible);
        virtual void setPositionStream( const Vector2DStream& stream );
        virtual void setSizeStream( const Vector2DStream& stream );
        virtual void setColorStream( const ColorStream& stream );
		mof::Vector2D getPreferredSize() const;



		static void append
        (
			std::vector<VertexXYZRHWCUV>& list ,
			const Rectangle<float>& region , 
			Color color ,
			const Rectangle<real>& textureCoordinates
		);

		static Sprite* createTextSprite
        (
			const Font& font , 
			const tstring& text
		);
    private:
        struct Impl;
		boost::scoped_ptr<Impl> m_pImpl;
	};


} // namespace mof
