#include <mof/id_pool.hpp>

namespace mof
{
//{{{ ctor
	id_pool::id_pool()
		: next_id_(0)
	{
		// Ȃ
	}
//}}}
//{{{ make_id
	size_t id_pool::make_id()
	{
		if (unused_list_.empty()) {
			// VKids
			return next_id_++;
		}
		else {
			// gĂȂid𔭍s
			size_t id = unused_list_.back();
			unused_list_.pop_back();
			return id;
		}
	}
//}}}
//{{{ release_id
	void id_pool::release_id(size_t id)
	{
		unused_list_.push_back(id);
	}
//}}}
//{{{ size
	size_t id_pool::size() const
	{
		return next_id_ - unused_list_.size();
	}
//}}}
}
