#pragma once
#include <boost/utility.hpp>
#include <vector>

namespace mof
{
	class id_pool : boost::noncopyable
	{
		std::vector<size_t> unused_list_;
		size_t next_id_;

	public:
		id_pool();

		size_t make_id();
		void release_id(size_t id);

		/**
		 * 現在発行中のidの数を返す
		 */
		size_t size() const;
	};

}
