#pragma once
#include <mof/Graphics3D.hpp>
#include <memory>

namespace mof
{

	class multi_solid : public Graphics3D
	{
	public :
		typedef std::shared_ptr<multi_solid> ptr;

		multi_solid(const Graphics3D::ptr& front, const Graphics3D::ptr& back);

		virtual ~multi_solid();

		virtual void update();

		virtual void setVisible(bool visible);
		
		virtual void draw() const;

		virtual void setTexture
		( 
			unsigned int num,
			const std::shared_ptr<mof::Texture>& pTexture
		);

		/*
		virtual void setMaterialBuilder
		( 
			unsigned int num,
			const std::shared_ptr<mof::MaterialBuilder>& material_builder
		);
		*/


		Graphics3D::ptr child(size_t index);

	private:
		struct impl;
		std::unique_ptr<impl> pimpl_;

	};

}// namespace mof

