#pragma once
#include "mof/sound/SoundBuffer.hpp"
#include <boost/thread.hpp>
#include "mof/sound/StreamingSoundLoader.hpp"

namespace mof{
namespace sound
{
	class DirectSoundDevice;
}
	class StreamSoundBuffer : public SoundBuffer
	{
		LPDIRECTSOUNDNOTIFY8 m_pSoundNotify;
		boost::thread* m_pLoadingThread;
		StreamingSoundLoader* m_pLoadingFunction;
		bool initialized_;
	public:
		StreamSoundBuffer(std::shared_ptr<mof::sound::DirectSoundDevice> pDevice, LPDIRECTSOUNDBUFFER8 pBuffer , LPDIRECTSOUNDNOTIFY8 pSoundNotify , SoundFile* pResource);
		virtual ~StreamSoundBuffer(void);
		virtual bool initialize();
		virtual bool play(bool looping);
		virtual void pause();
		virtual void stop();
	};

};
