 #pragma once
 #include <map>
 #include <stdexcept>
 #include <boost/function/function2.hpp>
 #include "mof/stream/KeyFrameAnimation.hpp"
 #include "mof/Matrix3D.hpp"
 
 
 
 namespace mof{
 
 
 class Rotation3D : public mof::Manipulator<mof::Matrix3D>{
 	mof::Manipulator<mof::Vector3D>::Handler  m_body;
 public:
	typedef std::pair<mof::frame_t, mof::Vector3D> keyframe_t;
 
 	Rotation3D(
 		const std::pair<mof::FrameNumber , mof::Vector3D>& front , 
 		const std::pair<mof::FrameNumber , mof::Vector3D>& back  
 		)
 	{
 		m_body = mof::makeKeyFrameAnimationHandler<mof::Vector3D>
        (
			front , back , &mof::linerInterpolate<mof::Vector3D> 
 		);
 	}
    
    Rotation3D
    (
 	    const mof::Manipulator<mof::Vector3D>::Handler&  body
 	)
    : m_body( body )
 	{
 	}
 
 	virtual mof::Matrix3D value( mof::FrameNumber frame) const{
 		return mof::Matrix3D::createRotation(m_body->value(frame));
 	}
 
 
 	/*mof::FrameNumber getFinalKeyFrameNumber(){
 		return m_pBody->getFinalKeyFrameNumber();
 	}*/
 
 
 };
 
 
 
 
 } //namespace mof
 
