#pragma once
#include <mof/widget/WidgetView.hpp>
#include <mof/stream/Manipulator.hpp>
#include <mof/Vector2D.hpp>
#include <memory>

namespace mof
{
namespace widget
{
//{{{ HorizontalClipping
	class HorizontalClipping : public mof::Manipulator<mof::Vector2D>
	{
	public:
		HorizontalClipping
		(
			const mof::Manipulator<mof::Vector2D>::Handler& parentSize, 
			float initialChildSize, 
			float border
		);

		virtual ~HorizontalClipping();

		virtual mof::Vector2D value(mof::FrameNumber fn) const;

	private:
		mof::Manipulator<mof::Vector2D>::Handler parentSize_;///< 親ウィジェットのサイズチャンネル
		const float initialParentSize_;					  ///< 初期の親ウィジェットのサイズ
		const float border_;								 ///< 初期の子ウィジェットの終点と親ウィジェットの終点との差
		const float initialChildSize_;					   ///< 子ウィジェットの初期サイズ
	};
//}}}
}// namespace widget
}// namespace mof
