#include <mof/widget/ImageView.hpp>
#include "mof/mofGraphics.hpp"
#include "mof/Font.hpp"
#include "mof/Sprite.hpp"
#include "mof/widget/Effect.hpp"
#include "mof/utilities.hpp"
#include "mof/widgets.hpp"
#include "mof/streams.hpp"
    
namespace mof
{
namespace widget
{
//{{{ struct Impl
    struct ImageView::Impl
    {
        Sprite* pSprite;
		mof::Vector2D preferredSize_;
    
        Impl( )
        : pSprite( NULL )
        {
        }
    
        ~Impl()
        {
            delete pSprite;
        }
    
    };
//}}}
//{{{ constructor
    ImageView::ImageView
    (
        const tstring& caption ,
        const Font& font
    )
    : 
        m_pImpl( new Impl ) 
    {
        { // 画像の生成
            m_pImpl->pSprite = Sprite::createTextSprite( font , caption );
            m_pImpl->pSprite->getPositionStream( ) << getPositionStream( ); 
            m_pImpl->pSprite->getColorStream( ) << getColorStream( ); 
			m_pImpl->preferredSize_ = m_pImpl->pSprite->getSizeStream().value();
			getSizeStream() << m_pImpl->preferredSize_;
        }
    }
//}}}
//{{{ constructor
    ImageView::ImageView
    (
        const TextureHandler& texture ,
        const Rectangle<float>& tRect
    )
    : 
        m_pImpl( new Impl( ) ) 
    {
        { // 画像の生成
            m_pImpl->pSprite = new Sprite( texture , tRect );
            m_pImpl->pSprite->getPositionStream( ) << getPositionStream( ); 
            m_pImpl->pSprite->getColorStream( ) << getColorStream( ); 
			m_pImpl->preferredSize_ = m_pImpl->pSprite->getSizeStream().value();
			getSizeStream() << m_pImpl->preferredSize_;
        }
        
    }
//}}}
//{{{ constructor
    ImageView::ImageView
    (
        const TextureHandler& texture 
    )
    : 
        m_pImpl( new Impl( ) ) 
    {
        { // 画像の生成
            m_pImpl->pSprite = new Sprite( texture , Rectangle<float>(0 , 0 , 1 , 1) );
            m_pImpl->pSprite->getPositionStream( ) << getPositionStream( ); 
            m_pImpl->pSprite->getColorStream( ) << getColorStream( ); 
			m_pImpl->preferredSize_ = m_pImpl->pSprite->getSizeStream().value();
			getSizeStream() << m_pImpl->preferredSize_;
        }
        
    }
//}}}
//{{{ destructor
    ImageView::~ImageView()
    {
    }
//}}}
//{{{ update
    void ImageView::update( )
    {
        m_positionStream.update( );
        m_sizeStream.update( );
        m_colorStream.update( );
        m_pImpl->pSprite->update();
    }
//}}}
//{{{ draw
    void ImageView::draw( ) const
    {
        m_pImpl->pSprite->draw( );
    }
//}}}
//{{{ setVisible
    void ImageView::setVisible(bool visible)
    {
        m_pImpl->pSprite->setVisible(visible);
    }
//}}}
//{{{ show
    FrameNumber ImageView::show(bool) 
    {
        return 0;
    }
//}}}
//{{{ hide
    FrameNumber ImageView::hide(bool)
    {
        return 0;
    }
//}}}
//{{{ focus
    FrameNumber ImageView::focus(bool) 
    {
        return 0;
    }
//}}}
//{{{ blur
    FrameNumber ImageView::blur(bool imidiately)
    {
        return 0;
    }
//}}}
//{{{ click
    FrameNumber ImageView::click(bool)
    {
        return 0;
    }
//}}}
//{{{ getPreferredSize
	mof::Vector2D ImageView::getPreferredSize() const
    {
        return m_pImpl->preferredSize_;
    }
//}}}
}
} // namespace mof
