#pragma once
#include "mof/widget/WidgetView.hpp"
#include "mof/graphics/utilities.hpp"
#include "mof/tstring.hpp"
#include <boost/scoped_ptr.hpp>

namespace mof
{
    class Font;

namespace widget
{

    class ImageView 
    : 
        public WidgetView
    {
    public:
    	ImageView( const tstring& caption , const Font& font );
    	ImageView( const TextureHandler& texture , const Rectangle<float>& tRect );
    	ImageView( const TextureHandler& texture );
    	virtual ~ImageView( );

        virtual FrameNumber show( bool imidiately = false );
        virtual FrameNumber hide( bool imidiately = false );
        virtual FrameNumber focus( bool imidiately = false );
        virtual FrameNumber blur( bool imidiately = false );
        virtual FrameNumber click( bool imidiately = false );
		virtual mof::Vector2D getPreferredSize() const;
        virtual void update( );
        virtual void draw( ) const;
        virtual void setVisible(bool visible);

    private:
        struct Impl;
    	boost::scoped_ptr<Impl> m_pImpl;
	
    };

}
}
