#include <mof/widget/OverlapLayout.hpp>
#include <mof/utilities.hpp>
#include <mof/widgets.hpp>
#include <mof/streams.hpp>
#include <algorithm>
#include <vector>
#include <mof/ConsoleIO.hpp>

using std::shared_ptr;
using mof::widget::WidgetView;
//{{{ Impl
struct mof::widget::OverlapLayout::Impl
{
	
    int width , height;
    size_t length;
    std::vector< shared_ptr<WidgetView> > views;

	Impl( const mof::Vector2D& size )
	: 
		width(size.x) , height(size.y) , length(0)
	{}
	

	~Impl()
    {
	}
};
//}}}
//{{{ OverlapLayout
mof::widget::OverlapLayout::OverlapLayout( const mof::Vector2D& size )
: m_pImpl( new Impl( size ) )
{
}
//}}}
//{{{ ~OverlapLayout
mof::widget::OverlapLayout::~OverlapLayout( )
{
}
//}}}
//{{{ add
void mof::widget::OverlapLayout::add(shared_ptr<WidgetView> pView)
{
    /*if(m_pImpl->length == 0 ){
	    m_pImpl->width = mof::real2int(size.x);
	    m_pImpl->width = mof::real2int(size.y);
    }*/
    m_pImpl->length++;
    m_pImpl->views.push_back(pView);
}
//}}}
//{{{ getLength
size_t mof::widget::OverlapLayout::getLength() const
{
    return m_pImpl->length;
}
//}}}
//{{{ getPreferredSize
mof::Vector2D mof::widget::OverlapLayout::getPreferredSize() const
{
    return mof::Vector2D(m_pImpl->width , m_pImpl->height);
}
//}}}
//{{{ connect
void mof::widget::OverlapLayout::connect(WidgetView* pParentView) 
{
    size_t i = 0;
    foreach(shared_ptr<WidgetView> pView , m_pImpl->views) 
    {
        pView->getPositionStream() << pParentView->getPositionStream();
        pView->getSizeStream() << pParentView->getSizeStream() << - pView->getSizeStream().value();
    }
}
//}}}
//{{{ getAdjacencyAsUp
int mof::widget::OverlapLayout::getAdjacencyAsUp(int index) const
{
    return mof::rotation_mod(index-1 , m_pImpl->length);
}
//}}}
//{{{ getAdjacencyAsDown
int mof::widget::OverlapLayout::getAdjacencyAsDown(int index) const
{
    return mof::rotation_mod(index+1 , m_pImpl->length );
}
//}}}
//{{{ getAdjacencyAsLeft
int mof::widget::OverlapLayout::getAdjacencyAsLeft(int index) const
{
    return mof::rotation_mod(index-1 , m_pImpl->length );
}
//}}}
//{{{ getAdjacencyAsRight
int mof::widget::OverlapLayout::getAdjacencyAsRight(int index) const
{
    return mof::rotation_mod(index+1 , m_pImpl->length );
}
//}}}
