#pragma once
#include <mof/widget/VerticalClipping.hpp>
#include <mof/ConsoleIO.hpp>

 
namespace mof
{
namespace widget
{
//{{{ constructor
	VerticalClipping::VerticalClipping
	(
		const mof::Manipulator<mof::Vector2D>::Handler& parentSize, 
		float initialChildSize, 
		float border
	)
		: parentSize_(parentSize), initialChildSize_(initialChildSize), border_(border), initialParentSize_(parentSize->value(0).y)
	{
	}
//}}}
//{{{ destructor
	VerticalClipping::~VerticalClipping() {}
//}}}
//{{{ value
	mof::Vector2D VerticalClipping::value(mof::FrameNumber fn) const
	{
		float currentParentSize = parentSize_->value(fn).y;
		float d = border_ + (currentParentSize - initialParentSize_);
		if (d > 0) return mof::Vector2D(0.0f, initialChildSize_);
		return initialChildSize_ + d < 0 ? mof::Vector2D(0, 0) : mof::Vector2D(0.0f, initialChildSize_ + d);
	}
//}}}
}// namespace widget
}// namespace mof
