#include "Action.h"
#include "BattlerFacade.h"
#include "mof/DataRow.h"
#include "mof/DataBasedAnimation.h"
#include "mof/KeyFrameAnimation.h"

et::Action::Action(et::BattlerFacade* pBattler , et::BattlerFacade* pTarget , int cost)
{
	m_pBattler = pBattler;
	if(pTarget != NULL)m_targetList.push_back(pTarget);
	m_cost = cost;
}



et::Action::Action(et::BattlerFacade* pBattler , std::vector<et::BattlerFacade*>& targetList , int cost)
{
	m_pBattler = pBattler;
	m_targetList = targetList;
	m_cost = cost;
}


et::Action::~Action(void)
{
}

void et::Action::setTargetList(std::vector<et::BattlerFacade*>& targetList){
	m_targetList = targetList;
}

std::vector<int> et::Action::doAction(){
	std::vector<int> result;
	et::BattlerParameter parameter = m_pBattler->getParameter();
	parameter.dActionPoint -= getAPCost();
	m_pBattler->setParameter(parameter);
	for(std::vector<BattlerFacade*>::iterator itr = m_targetList.begin() ; itr != m_targetList.end() ; ++itr){
		result.push_back(doActionTo(*itr));
	}
	return result;
}

mof::GraphicsSchedule* et::Action::createEffect(et::Common& common){
	mof::DataResource effectTable = common.m_pDataResourceManager->getResource(_T("data/effect/shock.csv"));

	mof::GraphicsSchedule* pSchedule = new mof::GraphicsSchedule();

	for(int i = 0 ; i < effectTable->getNumberOfRows() ; i++){
		mof::DataRow effectRow = mof::DataRow(effectTable , i);

		//---[V̍\
		mof::CascadeAnimation* pCascadeAnimation = new mof::CascadeAnimation();
		
		mof::KeyFrameAnimation* pCommonAnimation = new mof::KeyFrameAnimation();
		mof::Vector3D targetPosition = getTargetList().front()->getPosition();
		mof::Vector3D basePosition = m_pBattler->getGraphicsObject()->getPosition();
		//XP[vZ
		mof::Vector3D scale = targetPosition - basePosition;
		//if(scale.x < 0)scale.x = -scale.x;
		scale.y = scale.z = 1.0;
		pCommonAnimation->setPosition(0 , basePosition);
		mof::AnimationResource resource(pCommonAnimation);

		mof::tstring motionName(effectRow.getData(_T("Motion")));
		mof::DataBasedAnimation* pMotionAnimation = new mof::DataBasedAnimation(motionName.c_str() , scale);
		pCascadeAnimation->setElement(0 , mof::AnimationResource(pMotionAnimation));
		
		
		pCascadeAnimation->setElement(1 , resource);
		mof::AnimationResource animation(pCascadeAnimation);

		//---IuWFNg̍\
		mof::tstring className(effectRow.getData(_T("Class")));

		mof::tstring textureName(effectRow.getData(_T("Texture")));
		if(textureName == _T(""))textureName = _T("null");
		mof::TextureResource texture = common.m_pTextureManager->getResource(textureName.c_str());

		if(className == _T("Billboard")){
			//r{[h
			mof::GraphicsObject* pModel = new mof::Billboard(mof::Billboard::Y_FIXED , texture);
			pModel->setAnimation(0 , animation);
			pSchedule->add(20 , mof::GraphicsModelPtr(pModel) , animation);
		}
		else {
			//bV(classNamePath)
			mof::MeshResource pModel = common.m_pMeshManager->getResource(className.c_str());
			pModel->setTexture(0 , texture);
			pModel->setAnimation(0 , animation);
			pSchedule->add(20 , mof::GraphicsModelPtr(pModel) , animation);
		}
		
	}
	
	
	return pSchedule;
}