#include "AreaMenu.h"
#include "mof/KeyFrameAnimation.h"
#include "MyWindow.h"


et::AreaMenu::AreaMenu(et::Area& area , mof::TextureManager* pTextureManager , 
					   et::World* pWorld , et::GameData* pGameData , mof::Vector2D& position)
: et::MyFrame(mof::Line2D( 650 , 50 , 800 , 200) , true , pTextureManager->getResource(_T("image/frame0.png")) )
{
	m_pTextureManager = pTextureManager;
	m_pWorld = pWorld;
	m_pGameData = pGameData;
	m_position = position;
	m_pSelector = NULL;
	std::vector<mof::Window*> selectables;

	mof::Window* pSelectable = NULL;
	add(mof::Sprite::createSpriteFromText(_T("GAj[") , 16) );
	pSelectable = addSelectableTextItem(this , selectables , _T("K") , 16);
	if(!area.town)pSelectable->setAvailable(false);
	pSelectable = addSelectableTextItem(this , selectables , _T("Gg") , 16);
	if(area.hasSomethingIcon())pSelectable->setAvailable(false);
	addSelectableTextItem(this , selectables , _T("ǂ") , 16);
	m_pSelector = new mof::SelectionModel(selectables , mof::AnimationResource());
	setVisible(true);
}




et::AreaMenu::~AreaMenu(void)
{
	delete m_pSelector;
}




void et::AreaMenu::setVisible(bool visible){
	et::MyFrame::setVisible(visible);
	if(visible){
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
		pAnimation->setPosition(0 , mof::Vector2D(650 , 50));
		pAnimation->setPosition(7 , mof::Vector2D(440 , 50));
		mof::AnimationResource resource(pAnimation);
		m_pSelector->setMenuAnimation(resource);
		setAnimation(0 , resource);
	}
	else {
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
		pAnimation->setPosition(0 , mof::Vector2D(440 , 50));
		pAnimation->setPosition(7 , mof::Vector2D(650 , 50));
		mof::AnimationResource resource(pAnimation);
		m_pSelector->setMenuAnimation(resource);
		setAnimation(0 , resource);
	}
}

et::MyFrame* et::AreaMenu::performAction(){

	switch(getSelectionModel()->getSelectingIndex()){
		case 1 : //Ggzu
			{
			et::Area area = m_pWorld->getArea(m_position.x , m_position.y);
			area.forestGen = true;
			m_pWorld->setArea(m_position.x , m_position.y , area);
			m_pGameData->addRegenerationEvent(et::RegenerationEvent::createForestGenEvent(m_pWorld->getTerm() , m_position));
			setVisible(false);
			return NULL;
			}
		case 2 : //ǂ
			setVisible(false);
			return NULL;
		default :
			DEBUG_PRINT("`̃ANVv܂");
			return NULL;
	}
			
}

mof::Window* et::AreaMenu::addSelectableTextItem(mof::Window* pOwner, std::vector<mof::Window*>& selectables , TCHAR* text , int size){
	mof::Window* pSelectable = new et::MyWindow(mof::Sprite::createSpriteFromText(text , size) , m_pTextureManager);
	pOwner->add(pSelectable);
	selectables.push_back(pSelectable);
	return pSelectable;
}