#include "BattleData.h"
#include "mof/KeyFrameAnimation.h"
#include "AttackAction.h"
#include "SpecialAction.h"
#include "GameData.h"
#include "BattlerGroup.h"
#include "BattlerFacade.h"


et::BattleData::BattleData(mof::TextureManager* pTextureManager , et::GameData* pGameData , et::BattlerGroup* pGroup)
{
	m_pGameData = pGameData;
	m_pTextureManager = pTextureManager;
	m_battleAction.type = BattleAction::NONE;
	et::BattlerParameter parameter;
	m_pGroup = pGroup;
	//m_battlerList.push_back(new Battler(parameter , m_pTextureManager));
}

et::BattleData::~BattleData(void)
{
	delete m_pGroup;
}



/*
void et::BattleData::addBattler(et::BattlerFacade* pBattler){
	m_battlerList.push_back(pBattler);
}


void et::BattleData::layoutBattler(){
	int nEnemy = 0;
	int nIdeal = 0;
	
	//O
	for(std::list<BattlerFacade*>::iterator itr = m_battlerList.begin() ; itr != m_battlerList.end() ; ++itr){
		if((*itr)->getType() == et::ENEMY)nEnemy++;
		else if((*itr)->getType() == et::IDEAL)nIdeal++;
	}

	int cntEnemy = 0;
	int cntIdeal = 0;
	float zTable[3][3] = { {0.6f , 0.6f , 0.6f} , { 0.8f , 0.4f , 0.6f} , {0.86f , 0.6f , 0.34f} };//[][ԍ]
	float xTable[3][3] = { {0.0f , 0.0f , 0.0f} , { 0.1f , -0.1f , 0.6f} , {0.15f , 0.0f , -0.15f} };//[][ԍ]
	float ixTable[3][3] = { {0.2f , 0.0f , 0.0f} , { 0.0f , 0.07f , 0.6f} , {0.0f , 0.1f , 0.15f} };//[][ԍ]
	for(std::list<BattlerFacade*>::iterator itr = m_battlerList.begin() ; itr != m_battlerList.end() ; ++itr){
		if((*itr)->getType() == et::HERO){
			(*itr)->setAidlingAnimation(mof::Vector3D(0.3f , 0.0f , 0.6f));
			(*itr)->setBasePosition(mof::Vector3D(0.3f , 0.0f , 0.6f));
		}
		else if((*itr)->getType() == et::ENEMY){
			mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
			(*itr)->setAidlingAnimation(mof::Vector3D(-0.45f + xTable[nEnemy-1][cntEnemy] , 0.0f , zTable[nEnemy-1][cntEnemy]));
			(*itr)->setBasePosition(mof::Vector3D(-0.45f + xTable[nEnemy-1][cntEnemy] , 0.0f , zTable[nEnemy-1][cntEnemy]));
			cntEnemy++;	
		}
		else if((*itr)->getType() == et::IDEAL){
			mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
			(*itr)->setAidlingAnimation(mof::Vector3D(0.6 +ixTable[nIdeal-1][cntIdeal] , 0.0f , zTable[nIdeal-1][cntIdeal]));
			cntIdeal++;	
		}
	}

}


et::BattlerFacade* et::BattleData::getHeroBattler(){
	for(std::list<BattlerFacade*>::iterator itr = m_battlerList.begin() ; itr != m_battlerList.end() ; ++itr){
		if((*itr)->getType() == et::HERO){
			return *itr;
		}
	}
	assert(0);
	return NULL;
}

et::BattlerFacade* et::BattleData::getEnemyBattler(int index){
	int cntEnemy = 0;
	for(std::list<BattlerFacade*>::iterator itr = m_battlerList.begin() ; itr != m_battlerList.end() ; ++itr){
		if((*itr)->getType() == et::ENEMY){
			if(cntEnemy++ == index)return *itr;
		}
	}
	return NULL;

}


et::BattlerFacade* et::BattleData::getIdealBattler(int index){
	int cntIdeal = 0;
	for(std::list<BattlerFacade*>::iterator itr = m_battlerList.begin() ; itr != m_battlerList.end() ; ++itr){
		if((*itr)->getType() == et::IDEAL){
			if(cntIdeal++ == index)return *itr;
		}
	}
	return NULL;
}


et::Action* et::BattleData::createBattlerAction(et::BattlerFacade* pBattler){
	if(pBattler->getType() == et::HERO){
		et::BattleAction action = m_battleAction;
		m_battleAction.type = et::BattleAction::NONE;
		if(action.type == et::BattleAction::ATTACK_WEAPON){
			return new AttackAction(pBattler , action.pTarget , 3);
		}
		else if(action.type == et::BattleAction::WAIT || action.type == et::BattleAction::GUARD){
			return NULL;
		}
		else if(action.type == et::BattleAction::CAST){
			et::BattlerFacade* pIdeal = getIdealBattler(action.idealIndex);
			et::BattlerParameter parameter = pIdeal->getParameter();
			parameter.dActionPoint -= 5;
			pIdeal->setParameter(parameter);
			std::list<et::BattlerFacade*> targetList;
			if(action.pTarget != NULL)targetList.push_back(action.pTarget);
			else {
				for(std::list<et::BattlerFacade*>::const_iterator itr = getBattlerList().begin() ; itr != getBattlerList().end() ; ++itr){
					if((*itr)->getType() == et::ENEMY && (*itr)->getParameter().alive)targetList.push_back(*itr);
				}
			}
			//Z̎ނ𓾂
			return new SpecialAction(pBattler , targetList , 5 , action.idealIndex);
		}
		else if(action.type == et::BattleAction::USE_ITEM){
			//ACeȂ
			std::list<et::ItemData> &refList = getItemList();
			for(std::list<et::ItemData>::iterator itr = refList.begin() ; itr != refList.end() ; ++itr){
				if(action.pTargetItem == &(*itr)){
					refList.erase(itr);
					break;
				}
			}
			std::list<et::BattlerFacade*> targetList;
			if(action.pTarget != NULL)targetList.push_back(action.pTarget);
			else {
				for(std::list<et::BattlerFacade*>::const_iterator itr = getBattlerList().begin() ; itr != getBattlerList().end() ; ++itr){
					if((*itr)->getType() == et::ENEMY && (*itr)->getParameter().alive)targetList.push_back(*itr);
				}
			}
			//Z̎ނ𓾂
			return new SpecialAction(pBattler , targetList , 2 , 3);
		}
		else return NULL;
	}
	else {
		std::list<BattlerFacade*> enemyList;
		enemyList.push_back(getHeroBattler());
		std::list<BattlerFacade*> allyList;
		for(std::list<BattlerFacade*>::iterator itr = m_battlerList.begin() ; itr != m_battlerList.end() ; ++itr){
			if((*itr)->getType() == et::ENEMY && *itr != pBattler)allyList.push_back(*itr);
		}
		return pBattler->createNextAction(enemyList , allyList);
		
	}

}*/

et::BattleAction et::BattleData::pollBattleAction(){
	BattleAction action = m_battleAction;
	m_battleAction.type = BattleAction::NONE;
	return action;
}

bool et::BattleData::isOver(){
	if(!m_pGroup->getHeroBattler()->getParameter().alive)return true;
	//et::BattlerFacade* pEnemy = NULL;
	return m_pGroup->getEnemyBattlerListAlive().size() == 0;
	/*for(int i = 0 ; (pEnemy = m_pGroup->getEnemyBattlerAt(i)) != NULL ; i++){
		if(pEnemy->getParameter().alive)return false;
	}
	return true;*/
	
}


std::list<et::ItemData>& et::BattleData::getItemList(){
	return m_pGameData->getBattleItemList();
}
