#pragma once
#include <list>
#include "mof/Texture.h"
#include "Action.h"
#include "ItemData.h"

namespace et{

	class GameData;
	class BattlerGroup;

	struct BattleAction{
		enum ActionType{
			NONE , ATTACK_WEAPON , GUARD , WAIT , RUN_AWAY , CAST , USE_ITEM
		};

		ActionType type;
		int idealIndex;
		et::ItemData* pTargetItem;
		et::BattlerFacade* pTarget;

		BattleAction(){
			type = BattleAction::NONE;
		}
	};

	class BattleData
	{
		BattleAction m_battleAction;
		//std::list<BattlerFacade*> m_battlerList;
		mof::TextureManager* m_pTextureManager;
		et::GameData* m_pGameData;
		BattlerGroup* m_pGroup;
	public:
		BattleData(mof::TextureManager* pTextureManager , et::GameData* pGameData , et::BattlerGroup* pGroup);
		~BattleData(void);

		std::list<et::ItemData>& getItemList();

		mof::TextureManager* getTextureManager(){return m_pTextureManager;}
		//ogANVn
		void setBattleAction(BattleAction& action){m_battleAction = action;}
		bool hasBattleAction(){return !(m_battleAction.type == BattleAction::NONE);}
		BattleAction pollBattleAction();
		BattlerGroup* getBattlerGroup(){return m_pGroup;}

		
		bool isOver();
	};


}
