#pragma once
#include "GameScene.h"
#include "mof/Graphics.h"
#include "mof/Camera.h"
#include "mof/VertexBuffer.h"
#include "mof/VertexTypes.h"
#include "mof/Billboard.h"
#include <list>
#include "BattlerFacade.h"
#include "MyFrame.h"
#include "mof/AnimationScheduler.h"
#include "BattleData.h"
#include "BattleSystem.h"
#include "BattlerWindow.h"

namespace et{

	typedef std::vector<BattlerFacade*> BattlerList;
	class BattlerGroup;
	class FixedBattler;

	class BattleScene : public et::GameScene
	{
		mof::Sprite* m_back;
		mof::MeshResource m_field;
		mof::Camera* m_pCamera;

		et::BattleData* m_pBattleData;
		//BattlerList m_battlerList;

		//j[VXe
		MyFrame* m_pCurrentFrame;
		mof::AnimationResource m_menuChangeAnimation;
		mof::AnimationScheduler m_translationScheduler;
		std::list<mof::Container2D> m_menuStack;
		bool m_popFlag;
		bool m_clearFlag;

		//^[Ǘ
		mof::AnimationScheduler m_turnScheduler;
		et::BattleSystem* m_pBattleSystem;

		et::MyWindow* m_pBattleResultWindow;

		std::list<et::BattlerWindow*> m_battlerWindowList;
		et::FixedBattler* m_pHeroBattler;

		void layoutBattlers(BattlerGroup* pGroup);
	public:


		BattleScene(mof::TextureResource& nullTexture );
		virtual ~BattleScene(void);

		virtual bool initialize();
		virtual bool draw();
		virtual bool update();
		

	
	};

};
