#pragma once
#include "BattleData.h"
#include "mof/AnimationScheduler.h"
#include "mof/GraphicsSchedule.h"
#include "Action.h"
#include <vector>
#include "Common.h"

namespace et{

	

	class BattlerData;
	class BattlerFacade;


	class BattleSystem
	{
	protected :
		enum ActionState{
			APPROACH , EXECUTE , HIT, MAIN , SECESSION , READY , FINAL
		};
	private:
		et::BattleData* m_pBattleData;
		bool m_finalized;
		ActionState m_state;
		et::Action* m_pAction;
		std::vector<et::BattlerFacade*> m_battlerQueue;
		mof::AnimationScheduler* m_pScheduler;
		et::Common m_common;
		
		//XyVANVn
		mof::GraphicsSchedule* m_pChanceScheduler;
		bool m_succeeded;

		std::list<mof::GraphicsSchedule*> m_scheduleList;
	
			
	public:
		BattleSystem(et::BattleData* pBattleData , mof::AnimationScheduler* pScheduler , et::Common& common);
		~BattleSystem(void);
		void update();
		
		bool isFinalized();

		std::list<mof::GraphicsModelPtr>& getModelList( std::list<mof::GraphicsModelPtr>& modelList);
		void notifyPushKey();
	};

}

