#include "BattlerWindow.h"
#include "MyWindow.h"
#include "mof/GraphicsDevice.h"
#include "mof/KeyFrameAnimation.h"
#include <sstream>
#include <iomanip>

et::BattlerWindow::BattlerWindow( mof::TextureManager* pTextureManager , et::BattlerFacade* pBattler )
: et::MyFrame(mof::Line2D( 0 , 0 , 200 , 300) , true , pTextureManager->getResource(_T("image/frame1.png")))
{
	m_pTextureManager = pTextureManager;
	m_pBattler = pBattler;

	add(new et::MyWindow(mof::Sprite::createSpriteFromText(m_pBattler->getParameter().name , 12) , m_pTextureManager));
	m_pContent = new et::MyWindow(mof::Sprite::createSpriteFromText( _T(""), 12) , m_pTextureManager);
	resetView();
	add(m_pContent);
	setMargin(4);
	m_timeStamp = pBattler->getTimeStamp();

	//wiF
	mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
	pAnimation->setColor(0 , mof::createColor(127 , 255 , 255 , 255));
	this->setAnimation( 0 , mof::AnimationResource(pAnimation));
	setVisible(true);
}

et::BattlerWindow::~BattlerWindow(void)
{
	
}

bool et::BattlerWindow::draw(){
	if(!m_pBattler->getParameter().alive)return false;
	mof::Vector2D position = mof::GraphicsDevice::getInstance()->to2DPosition(m_pBattler->getPosition());
	position.x -= 32;
	position.y += 0;
	setPosition(position);
	return MyFrame::draw();
}

bool et::BattlerWindow::update(){
	if(m_pBattler->getTimeStamp() != m_timeStamp){
		m_timeStamp = m_pBattler->getTimeStamp();
		resetView();
	}
	return et::MyFrame::update();
	
}

void et::BattlerWindow::resetView(){
	std::basic_ostringstream<TCHAR> stream;
	if(m_pBattler->getType() != et::IDEAL){//_HP\͂Ȃ
		stream << _T("HP:") <<  std::setw(4) << m_pBattler->getParameter().hp << _T("/") << std::setw(4) << m_pBattler->getParameter().maxHp ;
	}
	stream << _T(" AP:") << m_pBattler->getParameter().actionPoint;
	m_pContent->setContent(mof::Sprite::createSpriteFromText(stream.str() , 12));
}