#ifndef CHARACTER_BOARD_HPP
#define CHARACTER_BOARD_HPP
#include <boost/scoped_ptr.hpp>
#include "mof/Component3D.hpp"
#include <list>
#include "mof/Board.hpp"
#include "mof/AnimationPlayer.hpp"


class CharacterBoard : public mof::AnimationPlayer
{
	struct Impl;
	boost::scoped_ptr<Impl> m_pImpl;
public:
	CharacterBoard( const mof::tstring& text);
	virtual ~CharacterBoard();

	virtual void setFrameNumber(mof::FrameNumber frame);
	virtual void nextFrame();
	virtual void prevFrame();

	virtual void update();
	

	void setWorldMatrix(const mof::Animation<mof::Matrix3D>::Handler& handler);
	mof::Matrix3D getWorldMatrix() const;
	mof::Vector3D getPosition() const;
	void append(std::list<mof::Board*>& list);

	void setFinishColor(mof::FrameNumber delay , mof::FrameNumber interval);
	void setPartColor(mof::FrameNumber delay , mof::FrameNumber interval);
};


#endif