#include "DataBasedAction.h"
#include "BattlerFacade.h"
#include "mof/DataBasedAnimation.h"
#include "mof/KeyFrameAnimation.h"

et::DataBasedAction::DataBasedAction(et::BattlerFacade* pBattler , et::BattlerFacade* pTarget , mof::DataRow& actionRow , int category)
: et::Action(pBattler , pTarget , actionRow.getIntegerData(_T("Cost")) )
{
	m_actionRow = actionRow;
	m_category = category;
}

et::DataBasedAction::~DataBasedAction(void)
{
}



int et::DataBasedAction::doActionTo(et::BattlerFacade* pTarget){
	float correction = (float)m_actionRow.getIntegerData(_T("Coefficient")) / 100.0;
	float totalPower = (float)m_pBattler->getParameter().attack;
	int damage = (int)totalPower - pTarget->getParameter().diffence;
	if(m_pBattler->getParameter().critical)damage = (int)totalPower;
	if(pTarget->getParameter().guard)damage *= 0.5;//K[hȂǃ_[W
	if(damage < 0)damage = 0;
	int effect = -damage;

	et::BattlerParameter parameter = pTarget->getParameter();
	if(parameter.hp <= damage){
		parameter.hp = 0;
		parameter.alive = false;
	}
	else parameter.hp -= damage;
	parameter.dActionPoint += 1;
	pTarget->setParameter(parameter);
	return effect;
}

mof::AnimationResource et::DataBasedAction::createApproachAnimation(){
	mof::Vector3D targetPosition = getTargetList().front()->getPosition();
	targetPosition.x += (m_pBattler->getType() == et::ENEMY ? -1 : 1 )* (isDirectAttack() ? 0.2f : 0.5f);
	return m_pBattler->setMovingAnimation(targetPosition , 15);
}


mof::AnimationResource et::DataBasedAction::createExecuteAnimation(){
	return m_pBattler->setCastAnimation(m_category);
}

mof::tstring et::DataBasedAction::getActionMessage(){
	mof::tstring message =  m_actionRow.getData(_T("Message"));
	if(message == _T("novalue"))return mof::tstring();
	else return message;
}


bool et::DataBasedAction::isDirectAttack(){
	return (m_category < 2);
}


mof::GraphicsSchedule* et::DataBasedAction::createEffect(et::Common& common){
	mof::tstring effect = m_actionRow.getData(_T("Effect"));
	/*if(effect == _T("Inherit")){
		//X^[^Cvp
	}*/
	mof::DataResource effectTable = common.m_pDataResourceManager->getResource(effect);

	mof::GraphicsSchedule* pSchedule = new mof::GraphicsSchedule();

	for(int i = 0 ; i < effectTable->getNumberOfRows() ; i++){
		mof::DataRow effectRow = mof::DataRow(effectTable , i);

		//---[V̍\
		mof::CascadeAnimation* pCascadeAnimation = new mof::CascadeAnimation();
		
		mof::KeyFrameAnimation* pCommonAnimation = new mof::KeyFrameAnimation();
		mof::Vector3D targetPosition = getTargetList().front()->getPosition();
		mof::Vector3D basePosition = m_pBattler->getGraphicsObject()->getPosition();
		//XP[vZ
		mof::Vector3D scale = targetPosition - basePosition;
		scale.y  = 1.0;
		pCommonAnimation->setPosition(0 , basePosition);
		mof::AnimationResource resource(pCommonAnimation);

		mof::tstring motionName(effectRow.getData(_T("Motion")));
		mof::DataBasedAnimation* pMotionAnimation = new mof::DataBasedAnimation(motionName.c_str() , scale);
		pCascadeAnimation->setElement(0 , mof::AnimationResource(pMotionAnimation));
		
		
		pCascadeAnimation->setElement(1 , resource);
		mof::AnimationResource animation(pCascadeAnimation);

		//---IuWFNg̍\
		mof::tstring className(effectRow.getData(_T("Class")));

		mof::tstring textureName(effectRow.getData(_T("Texture")));
		if(textureName == _T(""))textureName = _T("null");
		mof::TextureResource texture = common.m_pTextureManager->getResource(textureName.c_str());

		if(className == _T("Billboard")){
			//r{[h
			mof::GraphicsObject* pModel = new mof::Billboard(mof::Billboard::Y_FIXED , texture);
			pModel->setAnimation(0 , animation);
			pSchedule->add(effectRow.getIntegerData(_T("Delay")) , mof::GraphicsModelPtr(pModel) , animation);
		}
		else {
			//bV(classNamePath)
			mof::MeshResource pModel = common.m_pMeshManager->getResource(className.c_str());
			pModel->setTexture(0 , texture);
			pModel->setAnimation(0 , animation);
			pSchedule->add(effectRow.getIntegerData(_T("Delay")) , mof::GraphicsModelPtr(pModel) , animation);
		}
		
	}
	
	
	return pSchedule;

}